/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.metadata;

import it.tidalwave.image.Rational;
import it.tidalwave.image.metadata.DirectoryAdapter;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.tiff.TIFFTag;
import java.util.Date;
import java.util.NoSuchElementException;

public class DirectoryRawAdapter
implements DirectoryAdapter {
    private static final long serialVersionUID = 6849668666726854749L;
    private Directory directory;

    public DirectoryRawAdapter(Object directory) {
        if (directory == null) {
            throw new IllegalArgumentException();
        }
        this.directory = (Directory)directory;
    }

    public int[] getTags() {
        int[] result = new int[this.directory.tags().size()];
        int j = 0;
        for (TIFFTag tag : this.directory.tags()) {
            result[j++] = tag.getCode();
        }
        return result;
    }

    public String[] getSubDirectoryNames() {
        return this.directory.getSubDirectoryNames();
    }

    public DirectoryAdapter getSubDirectory(String name) {
        Directory subDirectory = this.directory.getNamedDirectory(name);
        return subDirectory != null ? new DirectoryRawAdapter(subDirectory) : null;
    }

    public Object getObject(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        Rational[] value = this.directory.getObject((Object)new Integer(tag));
        if (value instanceof TagRational) {
            TagRational rational = (TagRational)value;
            return new Rational(rational.getNumerator(), rational.getDenominator());
        }
        if (value instanceof TagRational[]) {
            value = this.convertRationalArray((TagRational[])value);
        }
        return value;
    }

    public String getTagName(int tag) {
        this.checkIfTagExists(tag);
        return this.directory.getTagName((Object)new Integer(tag));
    }

    public boolean containsTag(int tag) {
        return this.directory != null ? this.directory.containsTag((Object)new Integer(tag)) : false;
    }

    public int getInteger(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getInteger((Object)new Integer(tag));
    }

    public int getShort(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getInteger((Object)new Integer(tag));
    }

    public short[] getShortArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        int[] t = this.directory.getIntegers((Object)new Integer(tag));
        short[] s = new short[t.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (short)t[i];
        }
        return s;
    }

    public String[] getStringArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return new String[]{this.directory.getString((Object)new Integer(tag))};
    }

    public int[] getIntegerArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getIntegers((Object)new Integer(tag));
    }

    public int getByte(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getByte((Object)new Integer(tag));
    }

    public byte[] getByteArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getBytes((Object)new Integer(tag));
    }

    public double getDouble(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getDouble((Object)new Integer(tag));
    }

    public double[] getDoubleArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        throw new RuntimeException("Not implemented");
    }

    public float getFloat(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getFloat((Object)new Integer(tag));
    }

    public long getLong(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getInteger((Object)new Integer(tag));
    }

    public boolean getBoolean(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getInteger((Object)new Integer(tag)) != 0;
    }

    public Date getDate(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return null;
    }

    public Rational getRational(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        TagRational rational = this.directory.getRational((Object)new Integer(tag));
        return new Rational(rational.getNumerator(), rational.getDenominator());
    }

    public Rational[] getRationalArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.convertRationalArray(this.directory.getRationals((Object)new Integer(tag)));
    }

    public String getString(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getString((Object)new Integer(tag));
    }

    private void checkIfTagExists(int tag) throws NoSuchElementException {
        if (!this.containsTag(tag)) {
            throw new NoSuchElementException("" + tag);
        }
    }

    private Rational[] convertRationalArray(TagRational[] temp) {
        Rational[] r = new Rational[temp.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new Rational(temp[i].getNumerator(), temp[i].getDenominator());
        }
        return r;
    }
}

