/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.base.TxHelper;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.filter.ImportingDocumentFilter;
import org.nuxeo.ecm.platform.importer.listener.ImporterListener;
import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.ecm.platform.importer.threading.ImporterThreadingPolicy;
import org.nuxeo.runtime.api.Framework;

public class GenericThreadedImportTask
implements Runnable {
    private static final Log log = LogFactory.getLog(GenericThreadedImportTask.class);
    protected static int taskCounter = 0;
    protected boolean isRunning = false;
    protected long uploadedFiles = 0L;
    protected long uploadedKO;
    protected int batchSize;
    protected CoreSession session;
    protected DocumentModel rootDoc;
    protected SourceNode rootSource;
    protected Boolean skipContainerCreation = false;
    protected Boolean isRootTask = false;
    protected String taskId = null;
    protected TxHelper txHelper = new TxHelper();
    protected static final int TX_TIMEOUT = 600;
    protected ImporterThreadingPolicy threadPolicy;
    protected ImporterDocumentModelFactory factory;
    protected String jobName;
    protected List<ImporterListener> listeners = new ArrayList<ImporterListener>();
    protected List<ImportingDocumentFilter> importingDocumentFilters = new ArrayList<ImportingDocumentFilter>();
    protected ImporterLogger rsLogger = null;

    private static synchronized int getNextTaskId() {
        return ++taskCounter;
    }

    protected GenericThreadedImportTask(CoreSession session) {
        this.session = session;
        this.uploadedFiles = 0L;
        this.taskId = "T" + GenericThreadedImportTask.getNextTaskId();
    }

    public GenericThreadedImportTask(CoreSession session, SourceNode rootSource, DocumentModel rootDoc, boolean skipContainerCreation, ImporterLogger rsLogger, int batchSize, ImporterDocumentModelFactory factory, ImporterThreadingPolicy threadPolicy) throws Exception {
        this.rsLogger = rsLogger;
        this.session = session;
        this.batchSize = batchSize;
        this.uploadedFiles = 0L;
        this.taskId = "T" + GenericThreadedImportTask.getNextTaskId();
        this.rootSource = rootSource;
        this.rootDoc = rootDoc;
        this.skipContainerCreation = skipContainerCreation;
        this.factory = factory;
        this.threadPolicy = threadPolicy;
        if (rootSource == null) {
            throw new IllegalArgumentException("source node must be specified");
        }
    }

    public GenericThreadedImportTask(CoreSession session, SourceNode rootSource, DocumentModel rootDoc, boolean skipContainerCreation, ImporterLogger rsLogger, int batchSize, ImporterDocumentModelFactory factory, ImporterThreadingPolicy threadPolicy, String jobName) throws Exception {
        this(session, rootSource, rootDoc, skipContainerCreation, rsLogger, batchSize, factory, threadPolicy);
        this.jobName = jobName;
    }

    protected CoreSession getCoreSession() throws Exception {
        if (this.session == null) {
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            Repository repo = rm.getDefaultRepository();
            this.session = repo.open();
        }
        return this.session;
    }

    protected void commit() throws Exception {
        this.commit(false);
    }

    protected void commit(boolean force) throws Exception {
        ++this.uploadedFiles;
        if (this.uploadedFiles % 10L == 0L) {
            GenericMultiThreadedImporter.addCreatedDoc(this.taskId, this.uploadedFiles);
        }
        if (this.uploadedFiles % (long)this.batchSize == 0L || force) {
            Stopwatch stopwatch = SimonManager.getStopwatch((String)"org.nuxeo.ecm.platform.importer.session_save");
            Split split = stopwatch.start();
            this.fslog("Comiting Core Session after " + this.uploadedFiles + " files", true);
            this.getCoreSession().save();
            this.txHelper.commitOrRollbackTransaction();
            this.txHelper.beginNewTransaction(600);
            split.stop();
        }
    }

    protected DocumentModel doCreateFolderishNode(DocumentModel parent, SourceNode node) throws Exception {
        DocumentModel folder;
        if (!this.shouldImportDocument(node)) {
            return null;
        }
        Stopwatch stopwatch = SimonManager.getStopwatch((String)"org.nuxeo.ecm.platform.importer.create_folder");
        Split split = stopwatch.start();
        try {
            folder = this.getFactory().createFolderishNode(this.getCoreSession(), parent, node);
        }
        catch (Exception e) {
            String errorMsg = "Unable to create folderish document for " + node.getSourcePath() + ":" + e + (e.getCause() != null ? e.getCause() : "");
            this.fslog(errorMsg, true);
            log.error((Object)errorMsg);
            split.stop();
            throw new Exception(e);
        }
        if (folder != null) {
            String parentPath = parent == null ? "null" : parent.getPathAsString();
            this.fslog("Created Folder " + folder.getName() + " at " + parentPath, true);
        }
        split.stop();
        this.commit();
        return folder;
    }

    protected DocumentModel doCreateLeafNode(DocumentModel parent, SourceNode node) throws Exception {
        DocumentModel leaf;
        if (!this.shouldImportDocument(node)) {
            return null;
        }
        Stopwatch stopwatch = SimonManager.getStopwatch((String)"org.nuxeo.ecm.platform.importer.create_leaf");
        Split split = stopwatch.start();
        try {
            leaf = this.getFactory().createLeafNode(this.getCoreSession(), parent, node);
        }
        catch (Exception e) {
            String errMsg = "Unable to create leaf document for " + node.getSourcePath() + ":" + e + (e.getCause() != null ? e.getCause() : "");
            this.fslog(errMsg, true);
            log.error((Object)errMsg);
            split.stop();
            throw new Exception(e);
        }
        if (leaf != null && node.getBlobHolder() != null) {
            long fileSize = node.getBlobHolder().getBlob().getLength();
            String fileName = node.getBlobHolder().getBlob().getFilename();
            if (fileSize > 0L) {
                long kbSize = fileSize / 1024L;
                String parentPath = parent == null ? "null" : parent.getPathAsString();
                this.fslog("Created doc " + leaf.getName() + " at " + parentPath + " with file " + fileName + " of size " + kbSize + "KB", true);
            }
            this.uploadedKO += fileSize;
        }
        split.stop();
        this.commit();
        return leaf;
    }

    protected boolean shouldImportDocument(SourceNode node) {
        for (ImportingDocumentFilter importingDocumentFilter : this.importingDocumentFilters) {
            if (importingDocumentFilter.shouldImportDocument(node)) continue;
            return false;
        }
        return true;
    }

    protected GenericThreadedImportTask createNewTask(DocumentModel parent, SourceNode node, ImporterLogger log, Integer batchSize) throws Exception {
        GenericThreadedImportTask newTask = new GenericThreadedImportTask(null, node, parent, this.skipContainerCreation, log, batchSize, this.factory, this.threadPolicy);
        newTask.addListeners(this.listeners);
        newTask.addImportingDocumentFilters(this.importingDocumentFilters);
        return newTask;
    }

    protected GenericThreadedImportTask createNewTaskIfNeeded(DocumentModel parent, SourceNode node) {
        if (this.isRootTask.booleanValue()) {
            this.isRootTask = false;
            return null;
        }
        int scheduledTasks = GenericMultiThreadedImporter.getExecutor().getQueue().size();
        boolean createTask = this.getThreadPolicy().needToCreateThreadAfterNewFolderishNode(parent, node, this.uploadedFiles, this.batchSize, scheduledTasks);
        if (createTask) {
            GenericThreadedImportTask newTask;
            try {
                newTask = this.createNewTask(parent, node, this.rsLogger, this.batchSize);
            }
            catch (Exception e) {
                log.error((Object)"Error while starting new thread", (Throwable)e);
                return null;
            }
            newTask.setBatchSize(this.getBatchSize());
            newTask.setSkipContainerCreation(true);
            return newTask;
        }
        return null;
    }

    protected void recursiveCreateDocumentFromNode(DocumentModel parent, SourceNode node) throws Exception {
        if (this.getFactory().isTargetDocumentModelFolderish(node)) {
            DocumentModel folder;
            Boolean newThread = false;
            if (this.skipContainerCreation.booleanValue()) {
                folder = parent;
                this.skipContainerCreation = false;
                newThread = true;
            } else {
                folder = this.doCreateFolderishNode(parent, node);
                if (folder == null) {
                    return;
                }
            }
            GenericThreadedImportTask task = null;
            if (!newThread.booleanValue()) {
                task = this.createNewTaskIfNeeded(folder, node);
            }
            if (task != null) {
                this.commit(true);
                GenericMultiThreadedImporter.getExecutor().execute(task);
            } else {
                Stopwatch stopwatch = SimonManager.getStopwatch((String)"org.nuxeo.ecm.platform.importer.node_get_children");
                Split split = stopwatch.start();
                List<SourceNode> nodes = node.getChildren();
                split.stop();
                if (nodes != null) {
                    for (SourceNode child : nodes) {
                        this.recursiveCreateDocumentFromNode(folder, child);
                    }
                }
            }
        } else {
            this.doCreateLeafNode(parent, node);
        }
    }

    public void setInputSource(SourceNode node) {
        this.rootSource = node;
    }

    public void setTargetFolder(DocumentModel rootDoc) {
        this.rootDoc = rootDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        GenericThreadedImportTask genericThreadedImportTask = this;
        synchronized (genericThreadedImportTask) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        this.txHelper.beginNewTransaction(600);
        GenericThreadedImportTask genericThreadedImportTask = this;
        synchronized (genericThreadedImportTask) {
            if (this.isRunning) {
                throw new IllegalStateException("Task already running");
            }
            this.isRunning = true;
            if (this.rootSource == null) {
                this.isRunning = false;
                throw new IllegalArgumentException("source node must be specified");
            }
        }
        LoginContext lc = null;
        try {
            lc = Framework.login();
            this.recursiveCreateDocumentFromNode(this.rootDoc, this.rootSource);
            this.getCoreSession().save();
            GenericMultiThreadedImporter.addCreatedDoc(this.taskId, this.uploadedFiles);
            this.txHelper.commitOrRollbackTransaction();
        }
        catch (Exception e) {
            try {
                this.notifyImportError();
            }
            catch (Exception e1) {
                log.error((Object)"Error during import", (Throwable)e1);
            }
            log.error((Object)"Error during import", (Throwable)e);
        }
        finally {
            if (this.session != null) {
                CoreInstance.getInstance().close(this.session);
                this.session = null;
            }
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException e) {
                    log.error((Object)"Error while loging out!", (Throwable)e);
                }
            }
            GenericThreadedImportTask genericThreadedImportTask2 = this;
            synchronized (genericThreadedImportTask2) {
                this.isRunning = false;
            }
        }
    }

    public void dispose() {
        try {
            if (this.session != null) {
                CoreInstance.getInstance().close(this.session);
                this.session = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void fslog(String msg, boolean debug) {
        if (debug) {
            this.rsLogger.debug(msg);
        } else {
            this.rsLogger.info(msg);
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setSkipContainerCreation(Boolean skipContainerCreation) {
        this.skipContainerCreation = skipContainerCreation;
    }

    public void setRootTask() {
        this.isRootTask = true;
        taskCounter = 0;
        this.taskId = "T0";
    }

    protected ImporterThreadingPolicy getThreadPolicy() {
        return this.threadPolicy;
    }

    protected ImporterDocumentModelFactory getFactory() {
        return this.factory;
    }

    public void addImportingDocumentFilters(ImportingDocumentFilter ... importingDocumentFilters) {
        this.addImportingDocumentFilters(Arrays.asList(importingDocumentFilters));
    }

    public void addImportingDocumentFilters(Collection<ImportingDocumentFilter> importingDocumentFilters) {
        this.importingDocumentFilters.addAll(importingDocumentFilters);
    }

    public void addListeners(ImporterListener ... listeners) {
        this.addListeners(Arrays.asList(listeners));
    }

    public void addListeners(Collection<ImporterListener> listeners) {
        this.listeners.addAll(listeners);
    }

    protected void notifyImportError() throws Exception {
        for (ImporterListener listener : this.listeners) {
            listener.importError();
        }
    }

    protected void setRootDoc(DocumentModel rootDoc) {
        this.rootDoc = rootDoc;
    }

    protected void setRootSource(SourceNode rootSource) {
        this.rootSource = rootSource;
    }

    protected void setFactory(ImporterDocumentModelFactory factory) {
        this.factory = factory;
    }

    protected void setRsLogger(ImporterLogger rsLogger) {
        this.rsLogger = rsLogger;
    }

    protected void setThreadPolicy(ImporterThreadingPolicy threadPolicy) {
        this.threadPolicy = threadPolicy;
    }

    protected void setJobName(String jobName) {
        this.jobName = jobName;
    }
}

