/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.listener;

import java.io.IOException;
import java.io.Serializable;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.video.VideoHelper;

public class VideoChangedListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        Property origVideoProperty;
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("HasVideoPreview") && (origVideoProperty = doc.getProperty("file:content")).isDirty()) {
            try {
                Blob blob = (Blob)origVideoProperty.getValue(Blob.class);
                VideoHelper.updateVideoInfo(doc, blob);
                VideoHelper.updatePreviews(doc, blob);
                ctx.setProperty("videoChanged", (Serializable)Boolean.valueOf(true));
            }
            catch (IOException e) {
                throw ClientException.wrap((Throwable)e);
            }
        }
    }
}

