/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.importer;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class VideoImporter
extends AbstractFileImporter {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VideoImporter.class);

    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws ClientException, IOException {
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        String title = FileManagerUtils.fetchTitle((String)filename);
        DocumentModel docModel = FileManagerUtils.getExistingDocByTitle((CoreSession)documentManager, (String)path, (String)title);
        if (overwrite && docModel != null) {
            docModel.setPropertyValue("file:content", (Serializable)content);
            docModel.setPropertyValue("file:filename", (Serializable)((Object)filename));
        } else {
            PathSegmentService pss;
            try {
                pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
            docModel = documentManager.createDocumentModel("Video");
            docModel.setProperty("dublincore", "title", (Object)title);
            docModel.setPropertyValue("file:content", (Serializable)content);
            docModel.setPropertyValue("file:filename", (Serializable)((Object)filename));
            Type docType = typeService.getType("Video");
            if (docType != null) {
                String iconPath = docType.getIcon();
                docModel.setProperty("common", "icon", (Object)iconPath);
            }
            docModel.setPathInfo(path, pss.generatePathSegment(docModel));
            docModel = documentManager.createDocument(docModel);
        }
        return docModel;
    }
}

