/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.importer.core.helper;

import org.nuxeo.dam.exception.DamRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class UnrestrictedSessionRunnerHelper {
    private UnrestrictedSessionRunnerHelper() {
    }

    public static void runInNewThread(final UnrestrictedSessionRunner runner) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionHelper.startTransaction();
                    runner.runUnrestricted();
                }
                catch (ClientException e) {
                    TransactionHelper.setTransactionRollbackOnly();
                    throw new DamRuntimeException((Throwable)e);
                }
                finally {
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        });
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            throw new DamRuntimeException((Throwable)e);
        }
    }
}

