/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.rating.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityMessageHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jaxrs.io.JsonHelper;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonDocumentWriter;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.rating.api.LikeService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Services.MostLiked", category="Services", label="Like a document or an activity object")
public class MostLiked {
    private static final Log log = LogFactory.getLog(MostLiked.class);
    public static final String ID = "Services.MostLiked";
    public static Pattern HTTP_URL_PATTERN = Pattern.compile("\\b(https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])");
    @Context
    protected CoreSession session;
    @Context
    protected LikeService likeService;
    @Context
    protected ActivityStreamService activityService;
    @Context
    protected OperationContext ctx;
    @Param(name="contextPath")
    protected String contextPath;
    @Param(name="limit")
    protected int limit;
    @Param(name="fromDt", required=false)
    protected Date fromDt;
    @Param(name="toDt", required=false)
    protected Date toDt;
    @Param(name="documentLinkBuilder", required=false)
    protected String documentLinkBuilder;

    @OperationMethod
    public Blob run() throws Exception {
        ActivitiesList mostLikedDocuments = this.likeService.getMostLikedActivities(this.session, this.limit, this.session.getDocument((DocumentRef)new PathRef(this.contextPath)), this.fromDt, this.toDt);
        ArrayList<JSONObject> docsWithRate = new ArrayList<JSONObject>();
        for (Activity activity : mostLikedDocuments) {
            if (ActivityHelper.isDocument((String)activity.getTarget())) {
                docsWithRate.add(this.buildFromDocument(activity));
                continue;
            }
            if (ActivityHelper.isActivity((String)activity.getTarget())) {
                docsWithRate.add(this.buildFromActivity(activity));
                continue;
            }
            log.info((Object)"Unable to check activity type ...");
        }
        HashMap<String, JSONArray> jsonObj = new HashMap<String, JSONArray>();
        jsonObj.put("items", JSONArray.fromObject(docsWithRate));
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(JSONObject.fromObject(jsonObj).toString().getBytes("UTF-8")), "application/json");
    }

    protected JSONObject buildFromActivity(Activity activity) {
        Activity miniMessage = this.activityService.getActivity((Serializable)Long.valueOf(ActivityHelper.getActivityId((String)activity.getTarget())));
        String message = MostLiked.replaceURLsByLinks(miniMessage.getObject());
        Integer rating = Integer.valueOf(activity.getObject());
        Integer hasRated = Integer.valueOf(activity.getContext());
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("type", "minimessage");
        value.put("message", message);
        value.put("rating", rating);
        value.put("actor", ActivityHelper.getUsername((String)miniMessage.getActor()));
        value.put("profile", ActivityMessageHelper.getUserProfileLink((String)miniMessage.getActor(), (String)miniMessage.getDisplayActor()));
        value.put("hasUserLiked", hasRated);
        return JSONObject.fromObject(value);
    }

    protected JSONObject buildFromDocument(Activity activity) throws Exception {
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(ActivityHelper.getDocumentId((String)activity.getTarget())));
        Integer rating = Integer.valueOf(activity.getObject());
        Integer hasRated = Integer.valueOf(activity.getContext());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator jg = JsonHelper.createJsonGenerator((OutputStream)out);
        JsonDocumentWriter.writeDocument((JsonGenerator)jg, (DocumentModel)doc, (String[])new String[]{"dublincore", "common"}, (ServletRequest)this.getRequest());
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("rating", rating);
        value.put("document", JSONObject.fromObject((Object)((Object)out).toString()));
        value.put("url", this.getDocumentUrl(doc));
        value.put("hasUserLiked", hasRated);
        value.put("type", "document");
        return JSONObject.fromObject(value);
    }

    private ServletRequest getRequest() {
        Object request = this.ctx.get((Object)"request");
        if (request != null && request instanceof ServletRequest) {
            return (ServletRequest)request;
        }
        return null;
    }

    protected String getDocumentUrl(DocumentModel doc) {
        if (Framework.isTestModeSet()) {
            return "http://dummyurl.com";
        }
        DocumentViewCodecManager documentViewCodecManager = (DocumentViewCodecManager)Framework.getLocalService(DocumentViewCodecManager.class);
        String codecName = StringUtils.isBlank((String)this.documentLinkBuilder) ? documentViewCodecManager.getDefaultCodecName() : this.documentLinkBuilder;
        DocumentLocationImpl docLoc = new DocumentLocationImpl(this.session.getRepositoryName(), doc.getRef());
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, ((TypeInfo)doc.getAdapter(TypeInfo.class)).getDefaultView());
        return VirtualHostHelper.getContextPathProperty() + "/" + documentViewCodecManager.getUrlFromDocumentView(codecName, (DocumentView)docView, false, null);
    }

    protected static String replaceURLsByLinks(String message) {
        String escapedMessage = StringEscapeUtils.escapeHtml((String)message);
        Matcher m = HTTP_URL_PATTERN.matcher(escapedMessage);
        StringBuffer sb = new StringBuffer(escapedMessage.length());
        while (m.find()) {
            String url = m.group(1);
            m.appendReplacement(sb, MostLiked.computeLinkFor(url));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected static String computeLinkFor(String url) {
        return "<a href=\"" + url + "\" target=\"_top\">" + url + "</a>";
    }
}

