/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityMessage;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.runtime.api.Framework;

public class ActivitiesListImpl
extends ArrayList<Activity>
implements ActivitiesList {
    private static final long serialVersionUID = 1L;

    public ActivitiesListImpl() {
    }

    public ActivitiesListImpl(Collection<? extends Activity> c) {
        super(c);
    }

    @Override
    public ActivitiesList filterActivities(CoreSession session) {
        ActivitiesListImpl filteredActivities = new ActivitiesListImpl(this);
        Map<String, List<Activity>> activitiesByDocument = this.getActivitiesByDocument();
        List<String> authorizedDocuments = this.filterAuthorizedDocuments(activitiesByDocument.keySet(), session);
        for (String authorizedDocument : authorizedDocuments) {
            activitiesByDocument.remove(authorizedDocument);
        }
        ArrayList<Activity> unauthorizedActivities = new ArrayList<Activity>();
        for (List<Activity> activities : activitiesByDocument.values()) {
            unauthorizedActivities.addAll(activities);
        }
        filteredActivities.removeAll(unauthorizedActivities);
        return filteredActivities;
    }

    protected Map<String, List<Activity>> getActivitiesByDocument() {
        HashMap<String, List<Activity>> activitiesByDocuments = new HashMap<String, List<Activity>>();
        for (Activity activity : this) {
            List<String> relatedDocuments = this.getRelatedDocuments(activity);
            for (String doc : relatedDocuments) {
                ArrayList<Activity> value = (ArrayList<Activity>)activitiesByDocuments.get(doc);
                if (value == null) {
                    value = new ArrayList<Activity>();
                    activitiesByDocuments.put(doc, value);
                }
                value.add(activity);
            }
        }
        return activitiesByDocuments;
    }

    protected List<String> getRelatedDocuments(Activity activity) {
        ArrayList<String> relatedDocuments = new ArrayList<String>();
        String activityObject = activity.getActor();
        if (activityObject != null && ActivityHelper.isDocument(activityObject)) {
            relatedDocuments.add(ActivityHelper.getDocumentId(activityObject));
        }
        if ((activityObject = activity.getObject()) != null && ActivityHelper.isDocument(activityObject)) {
            relatedDocuments.add(ActivityHelper.getDocumentId(activityObject));
        }
        if ((activityObject = activity.getTarget()) != null && ActivityHelper.isDocument(activityObject)) {
            relatedDocuments.add(ActivityHelper.getDocumentId(activityObject));
        }
        return relatedDocuments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> filterAuthorizedDocuments(Set<String> allDocuments, CoreSession session) {
        ArrayList<String> arrayList;
        block7: {
            String idsParam = "('" + StringUtils.join((Object[])allDocuments.toArray(new String[allDocuments.size()]), (String)"', '") + "')";
            String query = String.format("SELECT ecm:uuid FROM Document WHERE ecm:uuid IN %s", idsParam);
            IterableQueryResult res = session.queryAndFetch(query, "NXQL", new Object[0]);
            try {
                ArrayList<String> authorizedDocuments = new ArrayList<String>();
                for (Map map : res) {
                    authorizedDocuments.add((String)map.get("ecm:uuid"));
                }
                arrayList = authorizedDocuments;
                if (res == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        res.close();
                    }
                    throw throwable;
                }
                catch (ClientException e) {
                    throw new ClientRuntimeException((Throwable)e);
                }
            }
            res.close();
        }
        return arrayList;
    }

    @Override
    public List<ActivityMessage> toActivityMessages(Locale locale) {
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ArrayList<ActivityMessage> messages = new ArrayList<ActivityMessage>();
        for (Activity activity : this) {
            messages.add(activityStreamService.toActivityMessage(activity, locale));
        }
        return messages;
    }

    @Override
    public List<ActivityMessage> toActivityMessages(Locale locale, String activityLinkBuilderName) {
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ArrayList<ActivityMessage> messages = new ArrayList<ActivityMessage>();
        for (Activity activity : this) {
            messages.add(activityStreamService.toActivityMessage(activity, locale, activityLinkBuilderName));
        }
        return messages;
    }

    @Override
    public List<Serializable> toActivityIds() {
        ArrayList<Serializable> activityIds = new ArrayList<Serializable>();
        for (Activity activity : this) {
            activityIds.add(activity.getId());
        }
        return activityIds;
    }
}

