/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.core;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;

public class CSVImportId {
    private static final Log log = LogFactory.getLog(CSVImportId.class);

    private CSVImportId() {
    }

    public static String create(String repositoryName, String path, Blob blob) {
        return CSVImportId.create(repositoryName, path, CSVImportId.computeDigest(blob));
    }

    public static String create(String repositoryName, String path, String csvBlobDigest) {
        return repositoryName + ':' + path + ":csvImport:" + csvBlobDigest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String computeDigest(Blob blob) {
        try (InputStream in = blob.getStream();){
            String string = DigestUtils.md5Hex((InputStream)blob.getStream());
            return string;
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            return "";
        }
    }
}

