/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.core.operation;

import java.io.File;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.csv.core.CSVImporter;
import org.nuxeo.ecm.csv.core.CSVImporterOptions;
import org.nuxeo.runtime.api.Framework;

@Operation(id="CSV.Import", category="Document", label="Import")
public class CSVImportOperation {
    public static final String ID = "CSV.Import";
    @Context
    protected CoreSession mSession;
    @Param(name="path")
    protected String mPath;
    @Param(name="sendReport", required=false)
    protected boolean mSendReport;
    @Param(name="documentMode", required=false)
    protected boolean mDocumentMode;

    @OperationMethod
    public String importCSV(File file) {
        CSVImporterOptions.ImportMode importMode = this.mDocumentMode ? CSVImporterOptions.ImportMode.IMPORT : CSVImporterOptions.ImportMode.CREATE;
        CSVImporterOptions options = new CSVImporterOptions.Builder().sendEmail(this.mSendReport).importMode(importMode).build();
        CSVImporter csvImporter = (CSVImporter)Framework.getService(CSVImporter.class);
        return csvImporter.launchImport(this.mSession, this.mPath, file, file.getName(), options);
    }

    @OperationMethod
    public String getStatus(String importID) {
        if (importID == null || importID.isEmpty()) {
            return null;
        }
        CSVImporter csvImporter = (CSVImporter)Framework.getLocalService(CSVImporter.class);
        return csvImporter.getImportStatus(importID).toString();
    }
}

