/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.operations.notification.MailTemplateHelper;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.csv.CSVImportId;
import org.nuxeo.ecm.csv.CSVImportLog;
import org.nuxeo.ecm.csv.CSVImportResult;
import org.nuxeo.ecm.csv.CSVImportStatus;
import org.nuxeo.ecm.csv.CSVImporter;
import org.nuxeo.ecm.csv.CSVImporterOptions;
import org.nuxeo.ecm.csv.Constants;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class CSVImporterWork
extends TransientStoreWork {
    public static final String NUXEO_CSV_MAIL_TO = "nuxeo.csv.mail.to";
    public static final String LABEL_CSV_IMPORTER_NOT_EXISTING_FIELD = "label.csv.importer.notExistingField";
    public static final String LABEL_CSV_IMPORTER_CANNOT_CONVERT_FIELD_VALUE = "label.csv.importer.cannotConvertFieldValue";
    public static final String LABEL_CSV_IMPORTER_NOT_EXISTING_FILE = "label.csv.importer.notExistingFile";
    public static final String NUXEO_CSV_BLOBS_FOLDER = "nuxeo.csv.blobs.folder";
    public static final String LABEL_CSV_IMPORTER_DOCUMENT_ALREADY_EXISTS = "label.csv.importer.documentAlreadyExists";
    public static final String LABEL_CSV_IMPORTER_UNABLE_TO_UPDATE = "label.csv.importer.unableToUpdate";
    public static final String LABEL_CSV_IMPORTER_DOCUMENT_UPDATED = "label.csv.importer.documentUpdated";
    public static final String LABEL_CSV_IMPORTER_UNABLE_TO_CREATE = "label.csv.importer.unableToCreate";
    public static final String LABEL_CSV_IMPORTER_PARENT_DOES_NOT_EXIST = "label.csv.importer.parentDoesNotExist";
    public static final String LABEL_CSV_IMPORTER_DOCUMENT_CREATED = "label.csv.importer.documentCreated";
    public static final String LABEL_CSV_IMPORTER_NOT_ALLOWED_SUB_TYPE = "label.csv.importer.notAllowedSubType";
    public static final String LABEL_CSV_IMPORTER_UNABLE_TO_SAVE = "label.csv.importer.unableToSave";
    public static final String LABEL_CSV_IMPORTER_ERROR_IMPORTING_LINE = "label.csv.importer.errorImportingLine";
    public static final String LABEL_CSV_IMPORTER_NOT_EXISTING_TYPE = "label.csv.importer.notExistingType";
    public static final String LABEL_CSV_IMPORTER_MISSING_TYPE_VALUE = "label.csv.importer.missingTypeValue";
    public static final String LABEL_CSV_IMPORTER_MISSING_NAME_VALUE = "label.csv.importer.missingNameValue";
    public static final String LABEL_CSV_IMPORTER_MISSING_NAME_COLUMN = "label.csv.importer.missingNameColumn";
    public static final String LABEL_CSV_IMPORTER_EMPTY_FILE = "label.csv.importer.emptyFile";
    public static final String LABEL_CSV_IMPORTER_ERROR_DURING_IMPORT = "label.csv.importer.errorDuringImport";
    public static final String LABEL_CSV_IMPORTER_EMPTY_LINE = "label.csv.importer.emptyLine";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CSVImporterWork.class);
    private static final String TEMPLATE_IMPORT_RESULT = "templates/csvImportResult.ftl";
    public static final String CATEGORY_CSV_IMPORTER = "csvImporter";
    public static final String CONTENT_FILED_TYPE_NAME = "content";
    public static List<String> AUTHORIZED_HEADERS = Arrays.asList("ecm:currentLifeCycleState");
    protected String parentPath;
    protected String username;
    protected File csvFile;
    protected String csvFileName;
    protected CSVImporterOptions options;
    protected transient DateFormat dateformat;
    protected boolean hasTypeColumn;
    protected Date startDate;
    protected ArrayList<CSVImportLog> importLogs = new ArrayList();
    static final Serializable EMPTY_LOGS = new ArrayList();

    public CSVImporterWork(String id) {
        super(id);
    }

    public CSVImporterWork(String repositoryName, String parentPath, String username, File csvFile, String csvFileName, CSVImporterOptions options) {
        super(CSVImportId.create(repositoryName, parentPath, csvFile));
        this.setDocument(repositoryName, null);
        this.setOriginatingUsername(username);
        this.parentPath = parentPath;
        this.username = username;
        this.csvFile = csvFile;
        this.csvFileName = csvFileName;
        this.options = options;
        this.startDate = new Date();
    }

    public String getCategory() {
        return CATEGORY_CSV_IMPORTER;
    }

    public String getTitle() {
        return String.format("CSV import in '%s'", this.parentPath);
    }

    public List<CSVImportLog> getImportLogs() {
        return new ArrayList<CSVImportLog>(this.importLogs);
    }

    public void work() {
        TransientStore store = CSVImporterWork.getStore();
        store.putParameter(this.id, "status", (Serializable)new CSVImportStatus(CSVImportStatus.State.RUNNING));
        this.setStatus("Importing");
        this.openUserSession();
        CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(new String[0]).withEscape(this.options.getEscapeCharacter()).withCommentMarker(this.options.getCommentMarker());
        try (BufferedReader in = this.newReader(this.csvFile);
             CSVParser parser = csvFormat.parse((Reader)in);){
            this.doImport(parser);
        }
        catch (IOException e) {
            this.logError(0L, "Error while doing the import: %s", LABEL_CSV_IMPORTER_ERROR_DURING_IMPORT, e.getMessage());
            log.debug((Object)e, (Throwable)e);
        }
        store.putParameter(this.id, "logs", this.importLogs);
        if (this.options.sendEmail()) {
            this.setStatus("Sending email");
            this.sendMail();
        }
        this.setStatus(null);
    }

    public void cleanUp(boolean ok, Exception e) {
        try {
            super.cleanUp(ok, e);
        }
        finally {
            CSVImporterWork.getStore().putParameter(this.id, "status", (Serializable)new CSVImportStatus(CSVImportStatus.State.COMPLETED));
        }
    }

    String launch() {
        WorkManager works = (WorkManager)Framework.getLocalService(WorkManager.class);
        String queueId = works.getCategoryQueueId(CATEGORY_CSV_IMPORTER);
        TransientStore store = CSVImporterWork.getStore();
        store.putParameter(this.id, "logs", EMPTY_LOGS);
        store.putParameter(this.id, "status", (Serializable)new CSVImportStatus(CSVImportStatus.State.SCHEDULED, 0, works.getMetrics((String)queueId).scheduled.intValue()));
        works.schedule((Work)this, WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED);
        return this.id;
    }

    static CSVImportStatus getStatus(String id) {
        TransientStore store = CSVImporterWork.getStore();
        if (!store.exists(id)) {
            return null;
        }
        return (CSVImportStatus)store.getParameter(id, "status");
    }

    static List<CSVImportLog> getLastImportLogs(String id) {
        TransientStore store = CSVImporterWork.getStore();
        if (!store.exists(id)) {
            return Collections.emptyList();
        }
        return (ArrayList)store.getParameter(id, "logs");
    }

    protected BufferedReader newReader(File file) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream((InputStream)new FileInputStream(file))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImport(CSVParser parser) {
        log.info((Object)String.format("Importing CSV file: %s", this.csvFileName));
        Map header = parser.getHeaderMap();
        if (header == null) {
            this.logError(0L, "No header line, empty file?", LABEL_CSV_IMPORTER_EMPTY_FILE, new String[0]);
            return;
        }
        if (!header.containsKey(Constants.CSV_NAME_COL)) {
            this.logError(0L, "Missing 'name' column", LABEL_CSV_IMPORTER_MISSING_NAME_COLUMN, new String[0]);
            return;
        }
        this.hasTypeColumn = header.containsKey(Constants.CSV_TYPE_COL);
        try {
            int batchSize = this.options.getBatchSize();
            long docsCreatedCount = 0L;
            for (CSVRecord record : parser) {
                if (record.size() == 0) {
                    this.importLogs.add(new CSVImportLog(record.getRecordNumber(), CSVImportLog.Status.SKIPPED, "Empty record", LABEL_CSV_IMPORTER_EMPTY_LINE, new String[0]));
                    continue;
                }
                try {
                    if (!this.importRecord(record, header) || ++docsCreatedCount % (long)batchSize != 0L) continue;
                    this.commitOrRollbackTransaction();
                    this.startTransaction();
                }
                catch (NuxeoException e) {
                    Throwable unwrappedException = CSVImporterWork.unwrapException(e);
                    this.logError(parser.getRecordNumber(), "Error while importing line: %s", LABEL_CSV_IMPORTER_ERROR_IMPORTING_LINE, unwrappedException.getMessage());
                    log.debug((Object)unwrappedException, unwrappedException);
                }
            }
            try {
                this.session.save();
            }
            catch (NuxeoException e) {
                Throwable ue = CSVImporterWork.unwrapException(e);
                this.logError(parser.getRecordNumber(), "Unable to save: %s", LABEL_CSV_IMPORTER_UNABLE_TO_SAVE, ue.getMessage());
                log.debug((Object)ue, ue);
            }
        }
        finally {
            this.commitOrRollbackTransaction();
            this.startTransaction();
        }
        log.info((Object)String.format("Done importing CSV file: %s", this.csvFileName));
    }

    protected boolean importRecord(CSVRecord record, Map<String, Integer> header) {
        String name = record.get(Constants.CSV_NAME_COL);
        if (StringUtils.isBlank((String)name)) {
            log.debug((Object)("record.isSet=" + record.isSet(Constants.CSV_NAME_COL)));
            this.logError(record.getRecordNumber(), "Missing 'name' value", LABEL_CSV_IMPORTER_MISSING_NAME_VALUE, new String[0]);
            return false;
        }
        Path targetPath = new Path(this.parentPath).append(name);
        name = targetPath.lastSegment();
        String newParentPath = targetPath.removeLastSegments(1).toString();
        boolean exists = this.options.getCSVImporterDocumentFactory().exists(this.session, newParentPath, name, null);
        PathRef docRef = null;
        String type = null;
        if (exists) {
            docRef = new PathRef(targetPath.toString());
            type = this.session.getDocument((DocumentRef)docRef).getType();
        } else {
            if (this.hasTypeColumn) {
                type = record.get(Constants.CSV_TYPE_COL);
            }
            if (StringUtils.isBlank(type)) {
                log.debug((Object)("record.isSet=" + record.isSet(Constants.CSV_TYPE_COL)));
                this.logError(record.getRecordNumber(), "Missing 'type' value", LABEL_CSV_IMPORTER_MISSING_TYPE_VALUE, new String[0]);
                return false;
            }
        }
        DocumentType docType = ((SchemaManager)Framework.getLocalService(SchemaManager.class)).getDocumentType(type);
        if (docType == null) {
            this.logError(record.getRecordNumber(), "The type '%s' does not exist", LABEL_CSV_IMPORTER_NOT_EXISTING_TYPE, type);
            return false;
        }
        Map<String, Serializable> properties = this.computePropertiesMap(record, (CompositeType)docType, header);
        if (properties == null) {
            return false;
        }
        long lineNumber = record.getRecordNumber();
        if (exists) {
            return this.updateDocument(lineNumber, (DocumentRef)docRef, properties);
        }
        return this.createDocument(lineNumber, newParentPath, name, type, properties);
    }

    protected Map<String, Serializable> computePropertiesMap(CSVRecord record, CompositeType compositeType, Map<String, Integer> header) {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (String headerValue : header.keySet()) {
            String lineValue = record.get(headerValue);
            lineValue = lineValue.trim();
            String fieldName = headerValue;
            if (Constants.CSV_NAME_COL.equals(headerValue) || Constants.CSV_TYPE_COL.equals(headerValue)) continue;
            if (AUTHORIZED_HEADERS.contains(headerValue) && !StringUtils.isBlank((String)lineValue)) {
                values.put(headerValue, (Serializable)((Object)lineValue));
                continue;
            }
            if (!compositeType.hasField(fieldName)) {
                fieldName = fieldName.split(":")[1];
            }
            if (!compositeType.hasField(fieldName) || StringUtils.isBlank((String)lineValue)) continue;
            Serializable convertedValue = this.convertValue(compositeType, fieldName, headerValue, lineValue, record.getRecordNumber());
            if (convertedValue == null) {
                return null;
            }
            values.put(headerValue, convertedValue);
        }
        return values;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Serializable convertValue(CompositeType compositeType, String fieldName, String headerValue, String stringValue, long lineNumber) {
        if (!compositeType.hasField(fieldName)) {
            this.logError(lineNumber, "Field '%s' does not exist on type '%s'", LABEL_CSV_IMPORTER_NOT_EXISTING_FIELD, headerValue, compositeType.getName());
            return null;
        }
        Field field = compositeType.getField(fieldName);
        if (field == null) return null;
        try {
            void var8_19;
            Object var8_7 = null;
            Type fieldType = field.getType();
            if (fieldType.isComplexType()) {
                if (!fieldType.getName().equals(CONTENT_FILED_TYPE_NAME)) {
                    Serializable serializable = (Serializable)ComplexTypeJSONDecoder.decode((ComplexType)((ComplexType)fieldType), (String)stringValue);
                    return var8_19;
                }
                String blobsFolderPath = Framework.getProperty((String)NUXEO_CSV_BLOBS_FOLDER);
                String path = FilenameUtils.normalize((String)(blobsFolderPath + "/" + stringValue));
                File file = new File(path);
                if (file.exists()) {
                    Serializable serializable = (Serializable)Blobs.createBlob((File)file);
                    return var8_19;
                }
                this.logError(lineNumber, "The file '%s' does not exist", LABEL_CSV_IMPORTER_NOT_EXISTING_FILE, stringValue);
                return null;
            }
            if (fieldType.isListType()) {
                Type listFieldType = ((ListType)fieldType).getFieldType();
                if (listFieldType.isSimpleType()) {
                    String[] stringArray = stringValue.split(this.options.getListSeparatorRegex());
                    return var8_19;
                }
                Serializable serializable = (Serializable)((Object)ComplexTypeJSONDecoder.decodeList((ListType)((ListType)fieldType), (String)stringValue));
                return var8_19;
            }
            Type type = field.getType();
            if (type instanceof SimpleTypeImpl) {
                type = type.getSuperType();
            }
            if (!type.isSimpleType()) return var8_19;
            if (type instanceof StringType) {
                String string = stringValue;
                return var8_19;
            }
            if (type instanceof IntegerType) {
                Integer n = Integer.valueOf(stringValue);
                return var8_19;
            }
            if (type instanceof LongType) {
                Long l = Long.valueOf(stringValue);
                return var8_19;
            }
            if (type instanceof DoubleType) {
                Double d = Double.valueOf(stringValue);
                return var8_19;
            }
            if (type instanceof BooleanType) {
                Boolean bl = Boolean.valueOf(stringValue);
                return var8_19;
            }
            if (!(type instanceof DateType)) return var8_19;
            Date date = this.getDateFormat().parse(stringValue);
            return var8_19;
        }
        catch (IOException | NumberFormatException | ParseException exception) {
            this.logError(lineNumber, "Unable to convert field '%s' with value '%s'", LABEL_CSV_IMPORTER_CANNOT_CONVERT_FIELD_VALUE, headerValue, stringValue);
            log.debug((Object)exception, (Throwable)exception);
            return null;
        }
    }

    protected DateFormat getDateFormat() {
        if (this.dateformat == null) {
            this.dateformat = new SimpleDateFormat(this.options.getDateFormat());
        }
        return this.dateformat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean createDocument(long lineNumber, String newParentPath, String name, String type, Map<String, Serializable> properties) {
        try {
            PathRef parentRef = new PathRef(newParentPath);
            if (!this.session.exists((DocumentRef)parentRef)) {
                this.logError(lineNumber, "Parent document '%s' does not exist", LABEL_CSV_IMPORTER_PARENT_DOES_NOT_EXIST, newParentPath);
                return false;
            }
            DocumentModel parent = this.session.getDocument((DocumentRef)parentRef);
            TypeManager typeManager = (TypeManager)Framework.getLocalService(TypeManager.class);
            if (this.options.checkAllowedSubTypes() && !typeManager.isAllowedSubType(type, parent.getType())) {
                this.logError(lineNumber, "'%s' type is not allowed in '%s'", LABEL_CSV_IMPORTER_NOT_ALLOWED_SUB_TYPE, type, parent.getType());
                return false;
            }
            this.options.getCSVImporterDocumentFactory().createDocument(this.session, newParentPath, name, type, properties);
            this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SUCCESS, "Document created", LABEL_CSV_IMPORTER_DOCUMENT_CREATED, new String[0]));
            return true;
        }
        catch (RuntimeException e) {
            Throwable unwrappedException = CSVImporterWork.unwrapException(e);
            this.logError(lineNumber, "Unable to create document: %s", LABEL_CSV_IMPORTER_UNABLE_TO_CREATE, unwrappedException.getMessage());
            log.debug((Object)unwrappedException, unwrappedException);
        }
        return false;
    }

    protected boolean updateDocument(long lineNumber, DocumentRef docRef, Map<String, Serializable> properties) {
        if (this.options.updateExisting()) {
            try {
                this.options.getCSVImporterDocumentFactory().updateDocument(this.session, docRef, properties);
                this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SUCCESS, "Document updated", LABEL_CSV_IMPORTER_DOCUMENT_UPDATED, new String[0]));
                return true;
            }
            catch (RuntimeException e) {
                Throwable unwrappedException = CSVImporterWork.unwrapException(e);
                this.logError(lineNumber, "Unable to update document: %s", LABEL_CSV_IMPORTER_UNABLE_TO_UPDATE, unwrappedException.getMessage());
                log.debug((Object)unwrappedException, unwrappedException);
            }
        } else {
            this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SKIPPED, "Document already exists", LABEL_CSV_IMPORTER_DOCUMENT_ALREADY_EXISTS, new String[0]));
        }
        return false;
    }

    protected void logError(long lineNumber, String message, String localizedMessage, String ... params) {
        this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.ERROR, String.format(message, params), localizedMessage, params));
        String lineMessage = String.format("Line %d", lineNumber);
        String errorMessage = String.format(message, params);
        log.error((Object)String.format("%s: %s", lineMessage, errorMessage));
    }

    protected void sendMail() {
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        NuxeoPrincipal principal = userManager.getPrincipal(this.username);
        String email = principal.getEmail();
        if (email == null) {
            log.info((Object)String.format("Not sending import result email to '%s', no email configured", this.username));
            return;
        }
        OperationContext ctx = new OperationContext(this.session);
        ctx.setInput((Object)this.session.getRootDocument());
        CSVImporter csvImporter = (CSVImporter)Framework.getLocalService(CSVImporter.class);
        List<CSVImportLog> importerLogs = csvImporter.getImportLogs(this.getId());
        CSVImportResult importResult = CSVImportResult.fromImportLogs(importerLogs);
        List<CSVImportLog> skippedAndErrorImportLogs = csvImporter.getImportLogs(this.getId(), CSVImportLog.Status.SKIPPED, CSVImportLog.Status.ERROR);
        ctx.put("importResult", (Object)importResult);
        ctx.put("skippedAndErrorImportLogs", skippedAndErrorImportLogs);
        ctx.put("csvFilename", (Object)this.csvFileName);
        ctx.put("startDate", (Object)DateFormat.getInstance().format(this.startDate));
        ctx.put("username", (Object)this.username);
        DocumentModel importFolder = this.session.getDocument((DocumentRef)new PathRef(this.parentPath));
        String importFolderUrl = this.getDocumentUrl(importFolder);
        ctx.put("importFolderTitle", (Object)importFolder.getTitle());
        ctx.put("importFolderUrl", (Object)importFolderUrl);
        ctx.put("userUrl", (Object)this.getUserUrl());
        StringList to = this.buildRecipientsList(email);
        Expression from = Scripting.newExpression((String)"Env[\"mail.from\"]");
        String subject = "CSV Import result of " + this.csvFileName;
        String message = CSVImporterWork.loadTemplate(TEMPLATE_IMPORT_RESULT);
        try {
            OperationChain chain = new OperationChain("SendMail");
            chain.add("Document.Mail").set("from", (Object)from).set("to", (Object)to).set("HTML", (Object)true).set("subject", (Object)subject).set("message", (Object)message);
            ((AutomationService)Framework.getLocalService(AutomationService.class)).run(ctx, chain);
        }
        catch (Exception e) {
            ExceptionUtils.checkInterrupt((Exception)e);
            log.error((Object)String.format("Unable to notify user '%s' for import result of '%s': %s", this.username, this.csvFileName, e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            throw ExceptionUtils.runtimeException((Exception)e);
        }
    }

    protected String getDocumentUrl(DocumentModel doc) {
        return MailTemplateHelper.getDocumentUrl((DocumentModel)doc, null);
    }

    protected String getUserUrl() {
        NotificationService notificationService = NotificationServiceHelper.getNotificationService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", this.username);
        DocumentViewImpl docView = new DocumentViewImpl(null, null, params);
        URLPolicyService urlPolicyService = (URLPolicyService)Framework.getLocalService(URLPolicyService.class);
        return urlPolicyService.getUrlFromDocumentView("user", (DocumentView)docView, notificationService.getServerUrlPrefix());
    }

    protected StringList buildRecipientsList(String userEmail) {
        String csvMailTo = Framework.getProperty((String)NUXEO_CSV_MAIL_TO);
        if (StringUtils.isBlank((String)csvMailTo)) {
            return new StringList(new String[]{userEmail});
        }
        return new StringList(new String[]{userEmail, csvMailTo});
    }

    private static String loadTemplate(String key) {
        InputStream io = CSVImporterWork.class.getClassLoader().getResourceAsStream(key);
        if (io != null) {
            try {
                String string = IOUtils.toString((InputStream)io, (Charset)Charsets.UTF_8);
                return string;
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
            finally {
                try {
                    io.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t != null) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return CSVImporterWork.unwrapException(cause);
    }
}

