/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.csv.CSVImporterDocumentFactory;

public class DefaultCSVImporterDocumentFactory
implements CSVImporterDocumentFactory {
    private static final long serialVersionUID = 1L;
    public static final List<String> IGNORE_FIELDS_ON_UPDATE = Arrays.asList("ecm:currentLifeCycleState");

    @Override
    public void createDocument(CoreSession session, String parentPath, String name, String type, Map<String, Serializable> values) {
        DocumentModel doc = session.createDocumentModel(parentPath, name, type);
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            if ("ecm:currentLifeCycleState".equals(entry.getKey())) {
                doc.putContextData("initialLifecycleState", entry.getValue());
                continue;
            }
            doc.setPropertyValue(entry.getKey(), entry.getValue());
        }
        session.createDocument(doc);
    }

    @Override
    public void updateDocument(CoreSession session, DocumentRef docRef, Map<String, Serializable> values) {
        DocumentModel doc = session.getDocument(docRef);
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            if (IGNORE_FIELDS_ON_UPDATE.contains(entry.getKey())) continue;
            doc.setPropertyValue(entry.getKey(), entry.getValue());
        }
        session.saveDocument(doc);
    }

    @Override
    public boolean exists(CoreSession session, String parentPath, String name, String type, Map<String, Serializable> values) {
        String targetPath = new Path(parentPath).append(name).toString();
        PathRef docRef = new PathRef(targetPath);
        return session.exists((DocumentRef)docRef);
    }
}

