/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.factories;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public abstract class AbstractDocumentModelFactory
implements ImporterDocumentModelFactory {
    private static final Log log = LogFactory.getLog(AbstractDocumentModelFactory.class);

    @Override
    public boolean isTargetDocumentModelFolderish(SourceNode node) {
        return node.isFolderish();
    }

    protected String getValidNameFromFileName(String fileName) {
        String name = IdUtils.generateId((String)fileName, (String)"-", (boolean)true, (int)100);
        name = name.replace("'", "");
        name = name.replace("(", "");
        name = name.replace(")", "");
        name = name.replace("+", "");
        return name;
    }

    protected DocumentModel setDocumentProperties(CoreSession session, Map<String, Serializable> properties, DocumentModel doc) throws ClientException {
        if (properties != null) {
            for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
                try {
                    doc.setPropertyValue(entry.getKey(), entry.getValue());
                }
                catch (PropertyNotFoundException e) {
                    String message = String.format("Property '%s' not found on document type: %s. Skipping it.", entry.getKey(), doc.getType());
                    log.debug((Object)message);
                }
            }
            doc = session.saveDocument(doc);
        }
        return doc;
    }
}

