/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.classification.core;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.classification.api.ClassificationService;
import org.nuxeo.ecm.classification.core.ClassificationDescriptor;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ClassificationServiceImpl
extends DefaultComponent
implements ClassificationService {
    public static final String NAME = "org.nuxeo.ecm.classification.core.ClassificationService";
    public static final String TYPES_XP = "types";
    private static final Log log = LogFactory.getLog(ClassificationServiceImpl.class);
    private static List<String> typeList;

    public void activate(ComponentContext context) {
        typeList = new LinkedList<String>();
    }

    public void deactivate(ComponentContext context) {
        typeList = new LinkedList<String>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(TYPES_XP)) {
            ClassificationDescriptor classificationDesc = (ClassificationDescriptor)contribution;
            String typeName = classificationDesc.getType();
            if (classificationDesc.isEnabled().booleanValue()) {
                typeList.add(typeName);
            } else if (typeList.contains(typeName)) {
                typeList.remove(typeName);
            }
        } else {
            log.error((Object)("Extension point " + extensionPoint + "is unknown"));
        }
    }

    public List<String> getClassifiableDocumentTypes() {
        return typeList;
    }

    public boolean isClassifiable(String docType) {
        if (typeList.contains(docType)) {
            return true;
        }
        try {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            Set facets = schemaManager.getDocumentType(docType).getFacets();
            return facets.contains("Classifiable");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isClassifiable(DocumentModel doc) {
        return doc.hasFacet("Classifiable") || typeList.contains(doc.getType());
    }
}

