/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.web;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="routeSecurityChecker")
@Install(precedence=10)
public class RouteSecurityChecker {
    @In(required=true, create=false)
    protected NuxeoPrincipal currentUser;
    @In(required=true, create=false)
    protected CoreSession documentManager;
    @In(create=true)
    private transient NavigationContext navigationContext;

    @Deprecated
    public boolean canValidateRoute() {
        try {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            if (!this.documentManager.hasChildren(currentDoc.getRef())) {
                return false;
            }
        }
        catch (ClientException e) {
            new RuntimeException(e);
        }
        return this.getDocumentRoutingService().canUserValidateRoute(this.currentUser);
    }

    public boolean canValidateRoute(DocumentModel routeDocument) throws ClientException {
        return this.canValidateRoute() || this.getDocumentRoutingService().canValidateRoute(routeDocument, this.documentManager);
    }

    public DocumentRoutingService getDocumentRoutingService() {
        try {
            return (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

