/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.importer;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.importer.factories.DefaultDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

public class CaseManagementCaseItemDocumentFactory
extends DefaultDocumentModelFactory {
    private String destionationMailboxPath;
    private CaseDistributionService caseDistributionService;
    private CaseManagementDocumentTypeService caseManagementDocumentTypeService;
    private EventProducer eventProducer;

    public DocumentModel createFolderishNode(CoreSession session, DocumentModel parent, SourceNode node) throws Exception {
        return null;
    }

    public DocumentModel createLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws Exception {
        return this.createCaseItemInCase(session, node);
    }

    protected String getMimeType(String name) {
        if (name.endsWith(".pdf")) {
            return "application/pdf";
        }
        return super.getMimeType(name);
    }

    protected DocumentModel createCaseItemInCase(CoreSession session, SourceNode node) throws Exception {
        this.caseDistributionService = this.getCaseDistributionService();
        if (this.caseDistributionService == null) {
            return null;
        }
        String caseRootPath = this.caseDistributionService.getParentDocumentPathForCase(session);
        DocumentModel caseItemDoc = this.defaultCreateNodeDoc(session, caseRootPath, node, this.getCaseManagementDocumentTypeService().getCaseItemType());
        if (caseItemDoc == null) {
            return null;
        }
        Case caseDoc = this.caseDistributionService.createCase(session, caseItemDoc, Collections.singletonList(this.getDestinationMailbox(session)));
        caseItemDoc = caseDoc.getFirstItem(session).getDocument();
        this.setPropertiesOnImport(session, caseItemDoc, caseDoc);
        this.caseDistributionService.createDraftCaseLink(session, this.getDestinationMailbox(session), caseDoc);
        this.notifyCaseImported(session, caseItemDoc, node);
        return caseItemDoc;
    }

    protected DocumentModel defaultCreateNodeDoc(CoreSession session, String parentPath, SourceNode node, String docType) throws Exception {
        String name;
        BlobHolder bh = node.getBlobHolder();
        String mimeType = bh.getBlob().getMimeType();
        if (mimeType == null) {
            mimeType = this.getMimeType(node.getName());
        }
        if ((name = this.getValidNameFromFileName(node.getName())).startsWith("imported-") || !mimeType.equals("application/pdf")) {
            return null;
        }
        String fileName = node.getName();
        HashMap options = new HashMap();
        DocumentModel doc = session.createDocumentModel(docType, options);
        doc.setPathInfo(parentPath, name);
        doc.setProperty("dublincore", "title", (Object)node.getName());
        doc.setProperty("file", "filename", (Object)fileName);
        doc.setProperty("file", "content", (Object)bh.getBlob());
        Map props = bh.getProperties();
        if (props != null) {
            for (String pName : props.keySet()) {
                doc.setPropertyValue(pName, (Serializable)props.get(pName));
            }
        }
        return doc;
    }

    private void setPropertiesOnImport(CoreSession session, DocumentModel caseItemDoc, Case caseDoc) throws Exception {
        caseItemDoc.setPropertyValue("cmdoc:defaultCaseId", (Serializable)((Object)caseDoc.getDocument().getId()));
        caseItemDoc.setPropertyValue("cmdoc:import_date", (Serializable)Calendar.getInstance());
        session.saveDocument(caseItemDoc);
    }

    protected CaseDistributionService getCaseDistributionService() throws Exception {
        if (this.caseDistributionService == null) {
            this.caseDistributionService = (CaseDistributionService)Framework.getService(CaseDistributionService.class);
        }
        return this.caseDistributionService;
    }

    private Mailbox getDestinationMailbox(CoreSession session) throws ClientException {
        DocumentModel docDestinationMailbox = session.getDocument((DocumentRef)new PathRef(this.destionationMailboxPath));
        return (Mailbox)docDestinationMailbox.getAdapter(Mailbox.class);
    }

    private CaseManagementDocumentTypeService getCaseManagementDocumentTypeService() throws Exception {
        if (this.caseManagementDocumentTypeService == null) {
            this.caseManagementDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        return this.caseManagementDocumentTypeService;
    }

    public String getDestionationMailboxPath() {
        return this.destionationMailboxPath;
    }

    public void setDestionationMailboxPath(String destionationMailboxPath) {
        this.destionationMailboxPath = destionationMailboxPath;
    }

    protected void notifyCaseImported(CoreSession coreSession, DocumentModel caseItemDoc, SourceNode node) {
        HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
        eventProperties.put("category", (Serializable)((Object)"cmImportCategory"));
        eventProperties.put("cmSourcePath", (Serializable)((Object)node.getSourcePath()));
        this.fireEvent(coreSession, caseItemDoc, eventProperties, "eventCmCaseImport");
    }

    protected void fireEvent(CoreSession coreSession, DocumentModel doc, Map<String, Serializable> eventProperties, String eventName) {
        try {
            DocumentEventContext envContext = new DocumentEventContext(coreSession, coreSession.getPrincipal(), doc);
            envContext.setProperties(eventProperties);
            this.getEventProducer().fireEvent(envContext.newEvent(eventName));
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    protected EventProducer getEventProducer() throws Exception {
        if (this.eventProducer == null) {
            this.eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        return this.eventProducer;
    }
}

