/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.caseimporter;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.service.caseimporter.CaseImporterThreadedTask;
import org.nuxeo.cm.core.service.caseimporter.CaseManagementCaseImporterDocumentsFactory;
import org.nuxeo.cm.core.service.caseimporter.CaseManagementImporterThreadingPolicy;
import org.nuxeo.cm.core.service.caseimporter.sourcenodes.CaseManagementSourceNode;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.service.caseimporter.AbstractXMLCaseReader;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.base.GenericThreadedImportTask;
import org.nuxeo.ecm.platform.importer.base.ImporterRunner;
import org.nuxeo.ecm.platform.importer.executor.AbstractImporterExecutor;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.ecm.platform.importer.threading.ImporterThreadingPolicy;

public class CaseImporter
extends AbstractImporterExecutor {
    private static final Log log = LogFactory.getLog(CaseImporter.class);
    private int noImportingThreads;
    private AbstractXMLCaseReader xmlCaseReader;
    private CaseManagementCaseImporterDocumentsFactory caseManagementCaseImporterDocumentsFactory;
    private CaseManagementImporterThreadingPolicy caseManagementImporterThreadingPolicy;
    private CaseImporterThreadedTask caseImporterThreadedTask;

    public CaseImporter(int noImportingThreads, AbstractXMLCaseReader xmlCaseReader) {
        this.noImportingThreads = noImportingThreads;
        this.xmlCaseReader = xmlCaseReader;
    }

    protected Log getJavaLogger() {
        return log;
    }

    public void importDocuments(String sourcePath) {
        FileSourceNode src = new FileSourceNode(sourcePath){

            public List<SourceNode> getChildren() {
                ArrayList<SourceNode> children = new ArrayList<SourceNode>();
                for (File child : this.file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".xml");
                    }
                })) {
                    children.add((SourceNode)new CaseManagementSourceNode(child, CaseImporter.this.xmlCaseReader));
                }
                return children;
            }
        };
        try {
            GenericMultiThreadedImporter importer = new GenericMultiThreadedImporter((SourceNode)src, "/case-management/case-root", Boolean.valueOf(true), Integer.valueOf(this.noImportingThreads), new Integer(this.noImportingThreads), this.getLogger());
            if (this.caseManagementCaseImporterDocumentsFactory == null) {
                this.setCaseManagementCaseImporterDocumentsFactory(new CaseManagementCaseImporterDocumentsFactory());
            }
            if (this.caseManagementImporterThreadingPolicy == null) {
                this.setCaseManagementImporterThreadingPolicy(new CaseManagementImporterThreadingPolicy());
            }
            if (this.caseImporterThreadedTask == null) {
                this.setCaseImporterThreadedTask(new CaseImporterThreadedTask(null));
            }
            importer.setFactory((ImporterDocumentModelFactory)this.caseManagementCaseImporterDocumentsFactory);
            importer.setThreadPolicy((ImporterThreadingPolicy)this.caseManagementImporterThreadingPolicy);
            importer.setRootImportTask((GenericThreadedImportTask)this.caseImporterThreadedTask);
            this.doRun((ImporterRunner)importer, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    public CaseManagementCaseImporterDocumentsFactory getCaseManagementCaseImporterDocumentsFactory() {
        return this.caseManagementCaseImporterDocumentsFactory;
    }

    public void setCaseManagementCaseImporterDocumentsFactory(CaseManagementCaseImporterDocumentsFactory caseManagementCaseImporterDocumentsFactory) {
        this.caseManagementCaseImporterDocumentsFactory = caseManagementCaseImporterDocumentsFactory;
    }

    public CaseManagementImporterThreadingPolicy getCaseManagementImporterThreadingPolicy() {
        return this.caseManagementImporterThreadingPolicy;
    }

    public void setCaseManagementImporterThreadingPolicy(CaseManagementImporterThreadingPolicy caseManagementImporterThreadingPolicy) {
        this.caseManagementImporterThreadingPolicy = caseManagementImporterThreadingPolicy;
    }

    public CaseImporterThreadedTask getCaseImporterThreadedTask() {
        return this.caseImporterThreadedTask;
    }

    public void setCaseImporterThreadedTask(CaseImporterThreadedTask caseImporterThreadedTask) {
        this.caseImporterThreadedTask = caseImporterThreadedTask;
    }
}

