/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.cm.core.service.CaseManagementDistributionTypeDescriptor;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.service.CaseManagementDistributionTypeService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CaseManagementDistributionTypeServiceImpl
extends DefaultComponent
implements CaseManagementDistributionTypeService {
    private static final long serialVersionUID = 1L;
    private static final int ALL_PROPERTY = 0;
    private static final int EXTERNAL_PROPERTY = 1;
    private static final int INTERNAL_PROPERTY = 2;
    private final Map<String, List<String>> values = new HashMap<String, List<String>>();

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        CaseManagementDistributionTypeDescriptor distributionType = (CaseManagementDistributionTypeDescriptor)contribution;
        List<String> properties = Arrays.asList(distributionType.allRecipientsProperty, distributionType.externalRecipientsProperty, distributionType.internalRecipientsProperty);
        this.values.put(distributionType.name, properties);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        CaseManagementDistributionTypeDescriptor distributionType = (CaseManagementDistributionTypeDescriptor)contribution;
        this.values.remove(distributionType.name);
    }

    public String getAllProperty(String distributionType) throws CaseManagementException {
        this.checkValue(distributionType, 0);
        return this.values.get(distributionType).get(0);
    }

    public Set<String> getDistributionTypes() {
        return this.values.keySet();
    }

    public String getExternalProperty(String distributionType) throws CaseManagementException {
        this.checkValue(distributionType, 1);
        return this.values.get(distributionType).get(1);
    }

    public String getInternalProperty(String distributionType) throws CaseManagementException {
        this.checkValue(distributionType, 2);
        return this.values.get(distributionType).get(2);
    }

    protected void checkValue(String distributionType, int distributionProperty) throws CaseManagementException {
        if (!this.values.containsKey(distributionType)) {
            throw new CaseManagementException(String.format("Unknown distribution type (%s). Check your DistributionTypeService contributions", distributionType));
        }
        if (this.values.get(distributionType).get(distributionProperty) == null) {
            throw new CaseManagementException(String.format("'%s' property is undefined. Check your DistributionTypeService contributions", distributionProperty));
        }
    }
}

