/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.persister;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.event.CreateMailboxRouteRootUnrestricted;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRoutingTreePersister;
import org.nuxeo.runtime.api.Framework;

public class CaseManagementDocRoutingTreePersister
extends DocumentRoutingTreePersister {
    protected static final Log log = LogFactory.getLog(CaseManagementDocRoutingTreePersister.class);
    public static final String QUERY_PERSONAL_ROUTE_ROOT = "SELECT * FROM RouteRoot WHERE ecm:parentId = '%s' AND dc:title= '%s'";

    public DocumentModel getParentFolderForNewModel(CoreSession session, DocumentModel instance) {
        try {
            MailboxManagementService service = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
            Mailbox userMailbox = service.getUserPersonalMailbox(session, session.getPrincipal().getName());
            String name = CreateMailboxRouteRootUnrestricted.getRouteRootNamePrefix() + userMailbox.getTitle();
            DocumentModelList children = session.query(String.format(QUERY_PERSONAL_ROUTE_ROOT, userMailbox.getDocument().getId(), name));
            if (children != null && !children.isEmpty()) {
                return (DocumentModel)children.get(0);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

