/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.persister;

import java.util.Date;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseTreeHelper;
import org.nuxeo.cm.service.CaseManagementPersister;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;

public abstract class CaseManagementAbstractPersister
implements CaseManagementPersister {
    protected String caseRootPath;

    public String getCaseRootPath() {
        if (this.caseRootPath == null) {
            return "/case-management/case-root";
        }
        return this.caseRootPath;
    }

    public void setCaseRootPath(String caseRootPath) {
        this.caseRootPath = caseRootPath;
    }

    public DocumentModel getParentDocumentForCase(CoreSession session) {
        return this.getParentDocumentForCase(session, null);
    }

    public String getParentDocumentPathForCase(CoreSession session) {
        return this.getParentDocumentPathForCase(session, null);
    }

    public DocumentModel getParentDocumentForCase(CoreSession session, Date date) {
        GetParentPathUnrestricted runner = new GetParentPathUnrestricted(session, date);
        try {
            runner.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return runner.getParentDocument();
    }

    public String getParentDocumentPathForCase(CoreSession session, Date date) {
        GetParentPathUnrestricted runner = new GetParentPathUnrestricted(session, date);
        try {
            runner.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return runner.getParentPath();
    }

    public String getParentDocumentPathForCaseItem(CoreSession session, Case kase) {
        return this.getParentDocumentPathForCase(session);
    }

    public class GetParentPathUnrestricted
    extends UnrestrictedSessionRunner {
        protected String parentPath;
        protected DocumentModel parent;
        protected Date date;

        public GetParentPathUnrestricted(CoreSession session, Date date) {
            super(session);
            this.date = date != null ? date : new Date();
        }

        public String getParentPath() {
            return this.parentPath;
        }

        public DocumentModel getParentDocument() {
            return this.parent;
        }

        public void run() throws ClientException {
            DocumentModel mailRootdoc = this.session.getDocument((DocumentRef)new PathRef(CaseManagementAbstractPersister.this.getCaseRootPath()));
            this.parent = CaseTreeHelper.getOrCreateDateTreeFolder((CoreSession)this.session, (DocumentModel)mailRootdoc, (Date)this.date, (String)"Folder");
            this.parentPath = this.parent.getPathAsString();
        }
    }
}

