/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class UpdateClassificationRootRightsListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        final DocumentModel doc = docCtx.getSourceDocument();
        if (!"ClassificationRoot".equals(doc.getType())) {
            return;
        }
        final String name = docCtx.getPrincipal().getName();
        CoreSession coreSession = docCtx.getCoreSession();
        new UnrestrictedSessionRunner(coreSession){

            public void run() throws ClientException {
                DocumentModel document = this.session.getDocument(doc.getRef());
                ACP acp = document.getACP();
                ACL acl = acp.getOrCreateACL("local");
                acl.add((Object)new ACE(name, "Classify", true));
                acp.addACL(acl);
                document.setACP(acp, true);
                this.session.saveDocument(document);
            }
        }.runUnrestricted();
    }
}

