/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;

public class RouteSecurityUpdaterListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext eventCtx = event.getContext();
        if (!(eventCtx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docEventCtx = (DocumentEventContext)eventCtx;
        DocumentModel kaseDoc = docEventCtx.getSourceDocument();
        if (!kaseDoc.hasFacet("Distributable") || kaseDoc.hasFacet("CaseGroupable")) {
            return;
        }
        CoreSession session = eventCtx.getCoreSession();
        Map recipients = (Map)((Object)eventCtx.getProperty("eventContextParticipants"));
        if (recipients == null) {
            return;
        }
        HashSet allMailboxIds = new HashSet();
        for (Map.Entry recipient : recipients.entrySet()) {
            allMailboxIds.addAll((Collection)recipient.getValue());
        }
        List relatedRoutes = this.getDocumentRoutingService().getDocumentRoutesForAttachedDocument(session, kaseDoc.getId());
        if (!allMailboxIds.isEmpty()) {
            for (DocumentRoute route : relatedRoutes) {
                DocumentModel routeDoc = route.getDocument();
                ACP acp = routeDoc.getACP();
                ACL routeACL = acp.getACL("mailboxes");
                ArrayList<ACE> newACEs = new ArrayList<ACE>();
                if (routeACL == null) {
                    routeACL = acp.getOrCreateACL("mailboxes");
                    ACL kaseACL = kaseDoc.getACP().getACL("mailboxes");
                    for (ACE a : kaseACL.getACEs()) {
                        if (!this.isReadFromMailboxId(a)) continue;
                        newACEs.add(new ACE(a.getUsername(), "Read", true));
                    }
                }
                for (String mailboxId : allMailboxIds) {
                    newACEs.add(new ACE("mailbox_" + mailboxId, "Read", true));
                }
                routeACL.addAll(newACEs);
                acp.removeACL("mailboxes");
                acp.addACL(routeACL);
                session.setACP(routeDoc.getRef(), acp, true);
            }
        }
    }

    protected boolean isReadFromMailboxId(ACE a) {
        try {
            String[] perms;
            PermissionProvider pm = (PermissionProvider)Framework.getService(PermissionProvider.class);
            for (String perm : perms = pm.getSubPermissions(a.getPermission())) {
                if (!"Read".equals(perm) && !"Everything".equals(perm)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected DocumentRoutingService getDocumentRoutingService() {
        try {
            DocumentRoutingService service = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
            if (service == null) {
                throw new RuntimeException("DocumentRoutingService is missing");
            }
            return service;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

