/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.util.List;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class CaseProcessedListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext eventCtx = event.getContext();
        String transiton = (String)((Object)eventCtx.getProperty("transition"));
        if (!"process".equals(transiton)) {
            return;
        }
        DocumentEventContext docCtx = null;
        if (!(eventCtx instanceof DocumentEventContext)) {
            return;
        }
        docCtx = (DocumentEventContext)eventCtx;
        DocumentModel kaseDoc = docCtx.getSourceDocument();
        Case kase = (Case)kaseDoc.getAdapter(Case.class);
        if (kase == null) {
            return;
        }
        try {
            RemoveWritePermissionUnrestricted session = new RemoveWritePermissionUnrestricted(eventCtx.getCoreSession(), kase);
            session.runUnrestricted();
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static class RemoveWritePermissionUnrestricted
    extends UnrestrictedSessionRunner {
        protected final Case kase;

        public RemoveWritePermissionUnrestricted(CoreSession session, Case kase) {
            super(session);
            this.kase = kase;
        }

        public void run() throws ClientException {
            List items = this.kase.getDocuments();
            items.add(this.kase.getDocument());
            for (DocumentModel doc : items) {
                ACP acp = doc.getACP();
                ACL processedAcl = acp.getOrCreateACL("processed");
                processedAcl.add((Object)new ACE("Everyone", "WriteLifeCycle", true));
                processedAcl.add((Object)new ACE("Everyone", "Write", false));
                acp.removeACL("processed");
                acp.addACL(0, processedAcl);
                this.session.setACP(doc.getRef(), acp, true);
            }
        }
    }
}

