/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.caselink;

import java.util.Calendar;
import org.nuxeo.cm.caselink.ActionableCaseLink;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;

public class ValidateDueCaseLinkUnrestricted
extends UnrestrictedSessionRunner {
    public static final String FETCH_DUE_ACTIONCASELINK_QUERY = "Select * FROM CaseLink WHERE ecm:currentLifeCycleState = 'todo' AND acslk:automaticValidation = 1 AND acslk:dueDate < TIMESTAMP '%s' ";

    public ValidateDueCaseLinkUnrestricted(CoreSession session) {
        super(session);
    }

    public void run() throws ClientException {
        String dateLiteral = DateLiteral.dateTimeFormatter.print(Calendar.getInstance().getTimeInMillis());
        String query = String.format(FETCH_DUE_ACTIONCASELINK_QUERY, dateLiteral);
        DocumentModelList dueCaseLinks = this.session.query(query);
        for (DocumentModel caseLinkdoc : dueCaseLinks) {
            ActionableCaseLink acl = (ActionableCaseLink)caseLinkdoc.getAdapter(ActionableCaseLink.class);
            acl.validate(this.session);
        }
    }
}

