/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.adapter;

import org.nuxeo.cm.caselink.ActionableCaseLinkImpl;
import org.nuxeo.cm.cases.HasParticipants;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.core.api.model.PropertyException;

public class CaseLinkAdapterFactory
implements DocumentAdapterFactory {
    public Object getAdapter(DocumentModel doc, Class arg1) {
        this.checkDocument(doc);
        HasParticipants adapter = (HasParticipants)doc.getAdapter(HasParticipants.class);
        return new ActionableCaseLinkImpl(doc, adapter);
    }

    protected void checkDocument(DocumentModel doc) {
        if (!doc.hasFacet("CaseLink")) {
            throw new CaseManagementRuntimeException("Document should have facet CaseLink");
        }
        if (!doc.hasSchema("distribution")) {
            throw new CaseManagementRuntimeException("Document should contain schema distribution");
        }
        if (!doc.hasSchema("case_link")) {
            throw new CaseManagementRuntimeException("Document should contain schema case_link");
        }
    }

    protected boolean isActionable(DocumentModel doc) {
        try {
            Boolean actionable = (Boolean)doc.getPropertyValue("cslk:isActionable");
            if (actionable == null) {
                return false;
            }
            return actionable;
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

