/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.disable.studio.snapshot.validation;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.client.we.StudioSnapshotHelper;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.admin.runtime.ReloadHelper;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

@Operation(id="Service.HotReloadStudioSnapshot", category="Services", label="Hot Reload Studio Snapshot Package", description="Updates Studio project with latest snapshot.")
public class HotReloadStudioSnapshotOverride {
    private static final Log log = LogFactory.getLog(HotReloadStudioSnapshotOverride.class);
    protected static final String inProgress = "updateInProgress";
    protected static final String success = "success";
    protected static final String error = "error";
    protected static final String dependencyMismatch = "dependencyMismatch";
    public static final String ID = "Service.HotReloadStudioSnapshot";
    protected static volatile boolean updateInProgress = false;
    @Context
    protected CoreSession session;
    @Context
    protected PackageManager pm;
    @Param(name="validate", required=false)
    protected boolean validate = true;

    protected boolean shouldValidate() {
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        if (cs.isBooleanPropertyTrue("studio.snapshot.disablePkgValidation")) {
            return false;
        }
        return this.validate;
    }

    protected static synchronized boolean setInProgress(boolean inProgress) {
        if (updateInProgress == inProgress) {
            return false;
        }
        updateInProgress = inProgress;
        return true;
    }

    @OperationMethod
    public Blob run() throws Exception {
        try {
            if (!HotReloadStudioSnapshotOverride.setInProgress(true)) {
                Blob blob = HotReloadStudioSnapshotOverride.jsonHelper(inProgress, "Update in progress.", null);
                return blob;
            }
            if (!((NuxeoPrincipal)this.session.getPrincipal()).isAdministrator()) {
                Blob blob = HotReloadStudioSnapshotOverride.jsonHelper(error, "Must be Administrator to use this function.", null);
                return blob;
            }
            if (!Framework.isDevModeSet()) {
                Blob blob = HotReloadStudioSnapshotOverride.jsonHelper(error, "You must enable Dev mode to Hot reload your Studio Snapshot package.", null);
                return blob;
            }
            List pkgs = this.pm.listRemoteAssociatedStudioPackages();
            DownloadablePackage snapshotPkg = StudioSnapshotHelper.getSnapshot((List)pkgs);
            if (snapshotPkg == null) {
                Blob blob = HotReloadStudioSnapshotOverride.jsonHelper(error, "No Snapshot Package was found.", null);
                return blob;
            }
            Blob blob = this.hotReloadPackage(snapshotPkg);
            return blob;
        }
        catch (RuntimeException e) {
            throw new OperationException((Throwable)e);
        }
        finally {
            HotReloadStudioSnapshotOverride.setInProgress(false);
        }
    }

    public Blob hotReloadPackage(DownloadablePackage remotePkg) {
        boolean useCompatReload;
        String packageId;
        if (this.shouldValidate()) {
            this.pm.flushCache();
            String targetPlatform = PlatformVersionHelper.getPlatformFilter();
            if (!TargetPlatformFilterHelper.isCompatibleWithTargetPlatform((Package)remotePkg, (String)targetPlatform)) {
                return HotReloadStudioSnapshotOverride.jsonHelper(error, String.format("This package is not validated for your current platform: %s", targetPlatform), null);
            }
            PackageDependency[] pkgDeps = remotePkg.getDependencies();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%s target platforms: %s", remotePkg, ArrayUtils.toString((Object)remotePkg.getTargetPlatforms())));
                log.debug((Object)String.format("%s dependencies: %s", remotePkg, ArrayUtils.toString((Object)pkgDeps)));
            }
            packageId = remotePkg.getId();
            if (pkgDeps != null && pkgDeps.length > 0) {
                DependencyResolution resolution = this.pm.resolveDependencies(packageId, targetPlatform);
                if (resolution.isFailed() && targetPlatform != null) {
                    resolution = this.pm.resolveDependencies(packageId, null);
                }
                if (resolution.isFailed()) {
                    return HotReloadStudioSnapshotOverride.jsonHelper(dependencyMismatch, String.format("Dependency check has failed for package '%s' (%s)", packageId, resolution), null);
                }
                List pkgToInstall = resolution.getInstallPackageIds();
                if ((pkgToInstall == null || pkgToInstall.size() != 1 || !packageId.equals(pkgToInstall.get(0))) && resolution.requireChanges()) {
                    ArrayList<String> dependencies = new ArrayList<String>();
                    for (String dependency : resolution.getInstallPackageNames()) {
                        if (dependency.contains(remotePkg.getName())) continue;
                        dependencies.add(dependency);
                    }
                    return HotReloadStudioSnapshotOverride.jsonHelper(dependencyMismatch, "A dependency mismatch has been detected. Please check your Studio project settings and your server configuration.", dependencies);
                }
            }
        }
        if (!(useCompatReload = Framework.isBooleanPropertyTrue((String)"nuxeo.hotreload.compat.mechanism"))) {
            log.info((Object)"Use hot reload update mechanism");
            ReloadHelper.hotReloadPackage((String)remotePkg.getId());
            return HotReloadStudioSnapshotOverride.jsonHelper(success, "Studio package installed.", null);
        }
        try {
            PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
            packageId = remotePkg.getId();
            LocalPackage pkg = pus.getPackage(packageId);
            if (pkg != null) {
                HotReloadStudioSnapshotOverride.removePackage(pus, pkg);
            }
            DownloadingPackage downloadingPkg = this.pm.download(packageId);
            while (!downloadingPkg.isCompleted()) {
                log.debug((Object)("Downloading studio snapshot package: " + packageId));
                Thread.sleep(100L);
            }
            log.info((Object)("Installing " + packageId));
            pkg = pus.getPackage(packageId);
            if (pkg == null || PackageState.DOWNLOADED != pkg.getPackageState()) {
                throw new NuxeoException("Error while downloading studio snapshot " + pkg);
            }
            Task installTask = pkg.getInstallTask();
            try {
                HotReloadStudioSnapshotOverride.performTask(installTask);
                return HotReloadStudioSnapshotOverride.jsonHelper(success, "Studio package installed.", null);
            }
            catch (PackageException e) {
                installTask.rollback();
                throw e;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
        catch (ConnectServerError | PackageException e) {
            throw new NuxeoException("Error while installing studio snapshot", e);
        }
    }

    protected static void removePackage(PackageUpdateService pus, LocalPackage pkg) throws PackageException {
        log.info((Object)String.format("Removing package %s before update...", pkg.getId()));
        if (pkg.getPackageState().isInstalled()) {
            log.info((Object)("Uninstalling " + pkg.getId()));
            Task uninstallTask = pkg.getUninstallTask();
            try {
                HotReloadStudioSnapshotOverride.performTask(uninstallTask);
            }
            catch (PackageException e) {
                uninstallTask.rollback();
                throw e;
            }
        }
        pus.removePackage(pkg.getId());
    }

    protected static void performTask(Task task) throws PackageException {
        ValidationStatus validationStatus = task.validate();
        if (validationStatus.hasErrors()) {
            throw new PackageException("Failed to validate package " + task.getPackage().getId() + " -> " + validationStatus.getErrors());
        }
        if (validationStatus.hasWarnings()) {
            log.warn((Object)("Got warnings on package validation " + task.getPackage().getId() + " -> " + validationStatus.getWarnings()));
        }
        task.run(null);
    }

    protected static Blob jsonHelper(String status, String message, List<String> dependencies) {
        JSONObject resultJSON = new JSONObject();
        JSONArray result = new JSONArray();
        resultJSON.put((Object)"status", (Object)status);
        resultJSON.put((Object)"message", (Object)message);
        if (dependencies != null) {
            resultJSON.put((Object)"deps", dependencies);
        }
        result.add((Object)resultJSON);
        return Blobs.createJSONBlob((String)result.toString());
    }
}

