/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.FunctionList;
import com.amazonaws.services.cloudfront.model.FunctionSummary;
import com.amazonaws.services.cloudfront.model.transform.FunctionSummaryStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class FunctionListStaxUnmarshaller
implements Unmarshaller<FunctionList, StaxUnmarshallerContext> {
    private static FunctionListStaxUnmarshaller instance;

    public FunctionList unmarshall(StaxUnmarshallerContext context) throws Exception {
        FunctionList functionList = new FunctionList();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return functionList;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NextMarker", targetDepth)) {
                    functionList.setNextMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxItems", targetDepth)) {
                    functionList.setMaxItems(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    functionList.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    functionList.withItems(new ArrayList<FunctionSummary>());
                    continue;
                }
                if (!context.testExpression("Items/FunctionSummary", targetDepth)) continue;
                functionList.withItems(FunctionSummaryStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return functionList;
    }

    public static FunctionListStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FunctionListStaxUnmarshaller();
        }
        return instance;
    }
}

