/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.FunctionSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TestResult
implements Serializable,
Cloneable {
    private FunctionSummary functionSummary;
    private String computeUtilization;
    private SdkInternalList<String> functionExecutionLogs;
    private String functionErrorMessage;
    private String functionOutput;

    public void setFunctionSummary(FunctionSummary functionSummary) {
        this.functionSummary = functionSummary;
    }

    public FunctionSummary getFunctionSummary() {
        return this.functionSummary;
    }

    public TestResult withFunctionSummary(FunctionSummary functionSummary) {
        this.setFunctionSummary(functionSummary);
        return this;
    }

    public void setComputeUtilization(String computeUtilization) {
        this.computeUtilization = computeUtilization;
    }

    public String getComputeUtilization() {
        return this.computeUtilization;
    }

    public TestResult withComputeUtilization(String computeUtilization) {
        this.setComputeUtilization(computeUtilization);
        return this;
    }

    public List<String> getFunctionExecutionLogs() {
        if (this.functionExecutionLogs == null) {
            this.functionExecutionLogs = new SdkInternalList();
        }
        return this.functionExecutionLogs;
    }

    public void setFunctionExecutionLogs(Collection<String> functionExecutionLogs) {
        if (functionExecutionLogs == null) {
            this.functionExecutionLogs = null;
            return;
        }
        this.functionExecutionLogs = new SdkInternalList(functionExecutionLogs);
    }

    public TestResult withFunctionExecutionLogs(String ... functionExecutionLogs) {
        if (this.functionExecutionLogs == null) {
            this.setFunctionExecutionLogs((Collection<String>)new SdkInternalList(functionExecutionLogs.length));
        }
        for (String ele : functionExecutionLogs) {
            this.functionExecutionLogs.add((Object)ele);
        }
        return this;
    }

    public TestResult withFunctionExecutionLogs(Collection<String> functionExecutionLogs) {
        this.setFunctionExecutionLogs(functionExecutionLogs);
        return this;
    }

    public void setFunctionErrorMessage(String functionErrorMessage) {
        this.functionErrorMessage = functionErrorMessage;
    }

    public String getFunctionErrorMessage() {
        return this.functionErrorMessage;
    }

    public TestResult withFunctionErrorMessage(String functionErrorMessage) {
        this.setFunctionErrorMessage(functionErrorMessage);
        return this;
    }

    public void setFunctionOutput(String functionOutput) {
        this.functionOutput = functionOutput;
    }

    public String getFunctionOutput() {
        return this.functionOutput;
    }

    public TestResult withFunctionOutput(String functionOutput) {
        this.setFunctionOutput(functionOutput);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionSummary() != null) {
            sb.append("FunctionSummary: ").append(this.getFunctionSummary()).append(",");
        }
        if (this.getComputeUtilization() != null) {
            sb.append("ComputeUtilization: ").append(this.getComputeUtilization()).append(",");
        }
        if (this.getFunctionExecutionLogs() != null) {
            sb.append("FunctionExecutionLogs: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getFunctionErrorMessage() != null) {
            sb.append("FunctionErrorMessage: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getFunctionOutput() != null) {
            sb.append("FunctionOutput: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestResult)) {
            return false;
        }
        TestResult other = (TestResult)obj;
        if (other.getFunctionSummary() == null ^ this.getFunctionSummary() == null) {
            return false;
        }
        if (other.getFunctionSummary() != null && !other.getFunctionSummary().equals(this.getFunctionSummary())) {
            return false;
        }
        if (other.getComputeUtilization() == null ^ this.getComputeUtilization() == null) {
            return false;
        }
        if (other.getComputeUtilization() != null && !other.getComputeUtilization().equals(this.getComputeUtilization())) {
            return false;
        }
        if (other.getFunctionExecutionLogs() == null ^ this.getFunctionExecutionLogs() == null) {
            return false;
        }
        if (other.getFunctionExecutionLogs() != null && !other.getFunctionExecutionLogs().equals(this.getFunctionExecutionLogs())) {
            return false;
        }
        if (other.getFunctionErrorMessage() == null ^ this.getFunctionErrorMessage() == null) {
            return false;
        }
        if (other.getFunctionErrorMessage() != null && !other.getFunctionErrorMessage().equals(this.getFunctionErrorMessage())) {
            return false;
        }
        if (other.getFunctionOutput() == null ^ this.getFunctionOutput() == null) {
            return false;
        }
        return other.getFunctionOutput() == null || other.getFunctionOutput().equals(this.getFunctionOutput());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctionSummary() == null ? 0 : this.getFunctionSummary().hashCode());
        hashCode = 31 * hashCode + (this.getComputeUtilization() == null ? 0 : this.getComputeUtilization().hashCode());
        hashCode = 31 * hashCode + (this.getFunctionExecutionLogs() == null ? 0 : this.getFunctionExecutionLogs().hashCode());
        hashCode = 31 * hashCode + (this.getFunctionErrorMessage() == null ? 0 : this.getFunctionErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.getFunctionOutput() == null ? 0 : this.getFunctionOutput().hashCode());
        return hashCode;
    }

    public TestResult clone() {
        try {
            return (TestResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

