/*
 * Decompiled with CFR 0.152.
 */
package io.maretha.summary.listeners;

import io.maretha.summary.services.SummaryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class BulkSummarizeListener
implements PostCommitEventListener {
    public static final String EXTRACT_SUMMARY_EVENT = "extractSummaryEvent";
    public static final String DISABLE_EXTRACT_SUMMARY_LISTENER = "disableExtractSummaryListener";
    private static final Log log = LogFactory.getLog(BulkSummarizeListener.class);

    public void handleEvent(EventBundle events) {
        events.forEach(this::handleEvent);
    }

    private void handleEvent(Event event) {
        if (!Framework.isInitialized()) {
            log.warn((Object)"Not processing; runtime not inialized");
            return;
        }
        log.debug((Object)("BulkSummarizeListener handle event:" + event.getName()));
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        String name = event.getName();
        if (!EXTRACT_SUMMARY_EVENT.equals(name)) {
            return;
        }
        Boolean block = (Boolean)event.getContext().getProperty(DISABLE_EXTRACT_SUMMARY_LISTENER);
        if (Boolean.TRUE.equals(block)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        boolean proccessSummary = ((SummaryService)Framework.getService(SummaryService.class)).processForSummarization(doc);
        if (log.isDebugEnabled()) {
            if (proccessSummary) {
                log.debug((Object)("Summary produced for document " + doc.getId()));
            } else {
                log.debug((Object)("Document too big, splitting text in chunks and summarizing " + doc.getId()));
            }
        }
    }
}

