/*
 * Decompiled with CFR 0.152.
 */
package io.maretha.summary.services;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.transfer.Download;
import io.maretha.summary.services.SummaryService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.PDFTextStripperByArea;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkBucket;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SummaryServiceImpl
extends DefaultComponent
implements SummaryService {
    private static final Log log = LogFactory.getLog(SummaryServiceImpl.class);
    protected OkHttpClient okHttpClient;

    @Override
    public boolean processForSummarization(DocumentModel doc) {
        String summary;
        Property blobProperty = doc.getProperty("file:content");
        Blob blob = (Blob)blobProperty.getValue();
        if (blob == null) {
            log.warn((Object)("No blob to summarize on document " + doc.getId()));
            return true;
        }
        String text = "";
        boolean needsSplitting = true;
        if (blob.getLength() < (long)MAX_APPROXIMATE_REQUEST_SIZE_FOR_REQUEST_PER_MODEL) {
            BlobHolder bh;
            if ("text/plain".equals(blob.getMimeType())) {
                text = this.streamTextBlobToString(blob);
            }
            if (Arrays.asList(MIME_TYPES_CONVERTIBLE_TO_PFD).contains(blob.getMimeType()) && (bh = (BlobHolder)doc.getAdapter(BlobHolder.class)) != null) {
                blob = this.convertBlobToPDF(bh);
            }
            if (blob == null) {
                this.saveStatus("Error. Document can not be converted to PDF, can not generate the summary", doc.getId());
                return true;
            }
            if (blob != null && "application/pdf".equals(blob.getMimeType())) {
                text = this.streamPDFBlobToString(blob);
            }
            if (StringUtils.isEmpty((CharSequence)text)) {
                log.warn((Object)("Could not proccess the blob as an accepted mime type to extract summary on document:" + doc.getId()));
                return true;
            }
            if (!this.doesTextNeedSplitting(text)) {
                needsSplitting = false;
            }
        }
        if (!(needsSplitting || StringUtils.isEmpty((CharSequence)(summary = this.summarizeText(text))) || "NOT PROCESSED, RETRYING".equals(summary))) {
            this.saveSummary("#1. " + summary, doc.getId());
            return true;
        }
        this.splitTextInChunksRecords(blob.getMimeType(), doc);
        return false;
    }

    @Override
    public String summarizeText(String text) {
        Response response;
        log.debug((Object)("Calling OpenAI endpoint for text: " + text));
        String responseBody = "";
        try {
            response = this.getOkHttpClient().newCall(this.constructRequest(text)).execute();
            responseBody = response.body().string();
        }
        catch (IOException e) {
            log.error((Object)e);
            return "NOT PROCESSED, RETRYING";
        }
        if (!response.isSuccessful()) {
            String message = "Unexpected response from API status: " + response.code() + " body: " + responseBody;
            log.error((Object)message);
            response.close();
            return "NOT PROCESSED, RETRYING";
        }
        JSONObject responseObject = new JSONObject(responseBody);
        log.debug((Object)("API ResponseObject: " + responseObject));
        String summarizedTex = responseObject.getJSONArray("choices").getJSONObject(0).getString("text").trim();
        response.close();
        return summarizedTex;
    }

    @Override
    public void saveSummary(String summary, String docId) {
        TransactionHelper.runInTransaction(() -> {
            String defaultRepositoryName = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName();
            CoreInstance.doPrivileged((String)defaultRepositoryName, session -> {
                DocumentModel document = session.getDocument((DocumentRef)new IdRef(docId));
                if (!document.hasFacet("SummaryFacet")) {
                    document.addFacet("SummaryFacet");
                }
                if (StringUtils.isNotEmpty((CharSequence)summary) && StringUtils.isNotEmpty((CharSequence)summary.trim())) {
                    document.setPropertyValue("summary:summary", (Serializable)((Object)summary));
                    document.setPropertyValue("summary:status", (Serializable)((Object)"Done"));
                    document.setPropertyValue("summary:lastComputed", (Serializable)GregorianCalendar.getInstance());
                } else {
                    document.setPropertyValue("summary:summary", (Serializable)((Object)"Summary could not be computed"));
                    document.setPropertyValue("summary:status", (Serializable)((Object)"Error"));
                }
                this.disableListeners(document);
                document = session.saveDocument(document);
                log.debug((Object)("Summary saved for documentId: " + docId));
            });
        });
    }

    @Override
    public void saveStatus(String status, String docId) {
        TransactionHelper.runInTransaction(() -> {
            String defaultRepositoryName = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName();
            CoreInstance.doPrivileged((String)defaultRepositoryName, session -> {
                DocumentModel document = session.getDocument((DocumentRef)new IdRef(docId));
                if (!document.hasFacet("SummaryFacet")) {
                    document.addFacet("SummaryFacet");
                }
                document.setPropertyValue("summary:status", (Serializable)((Object)status));
                this.disableListeners(document);
                document = session.saveDocument(document);
                log.debug((Object)("Summary status saved for documentId: " + docId + " as " + status));
            });
        });
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        TransactionHelper.startTransaction();
    }

    @Override
    public List<String> getSupportedMimeTypes() {
        ArrayList<String> allSupportedMimeTypes = new ArrayList<String>();
        allSupportedMimeTypes.add("text/plain");
        allSupportedMimeTypes.add("application/pdf");
        allSupportedMimeTypes.addAll(Arrays.asList(MIME_TYPES_CONVERTIBLE_TO_PFD));
        return allSupportedMimeTypes;
    }

    protected void splitTextInChunksRecords(String mimeType, DocumentModel doc) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob blob = null;
        if ("application/pdf".equals(mimeType)) {
            blob = bh.getBlob();
        } else if (bh != null) {
            blob = this.convertBlobToPDF(bh);
        }
        if (blob == null) {
            this.saveStatus("Error. Document can not be converted to PDF, can not generate the summary", doc.getId());
            return;
        }
        this.streamPDFBlobAndSubmitForProcessing(blob, doc.getId());
    }

    protected OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = new OkHttpClient.Builder().connectTimeout((long)MAX_DELAY, TimeUnit.SECONDS).writeTimeout((long)MAX_DELAY, TimeUnit.SECONDS).readTimeout((long)MAX_DELAY, TimeUnit.SECONDS).build();
        }
        return this.okHttpClient;
    }

    protected Request constructRequest(String text) {
        JSONObject jsonBody = new JSONObject().put("model", (Object)MODEL).put("prompt", (Object)(text + "\n\nTl;dr")).put("temperature", Double.parseDouble(TEMPERATURE)).put("max_tokens", Integer.parseInt(MAX_TOKENS_IN_RESPONSE)).put("top_p", Double.parseDouble(TOP_P)).put("frequency_penalty", Double.parseDouble(FREQUENCY_PENALTY)).put("presence_penalty", Double.parseDouble(PRESENCE_PENALTY));
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)jsonBody.toString());
        log.debug((Object)("API Request body: " + jsonBody));
        return new Request.Builder().url(this.getApiUrl()).header("Authorization", "Bearer " + AUTH_TOKEN).post(requestBody).build();
    }

    @Override
    public String formatPageTextForProcessing(String docId, int pageNo, String text) {
        return String.format("DOC%sPAGE%sTEXT%s", docId, pageNo, text);
    }

    protected boolean doesTextNeedSplitting(String text) {
        int currentModelTokensLimit = Integer.parseInt(MODEL_TOKENS_LIMIT);
        int maxTokensExpectedInResponse = Integer.parseInt(MAX_TOKENS_IN_RESPONSE);
        int maxTokensToBeSent = currentModelTokensLimit - maxTokensExpectedInResponse - 300;
        if (text == null || text.trim().isEmpty()) {
            return false;
        }
        String[] tokens = text.split("\\s+");
        return tokens.length > maxTokensToBeSent;
    }

    protected File getMainBlobAsFileFromS3(DocumentModel doc) throws IOException {
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider("default");
        BinaryManager bm = blobProvider.getBinaryManager();
        if (bm == null || !(bm instanceof S3BinaryManager)) {
            log.error((Object)"Can not get an instance of the S3BinaryManager");
        }
        S3BinaryManager s3bm = (S3BinaryManager)bm;
        String digest = (String)((Object)doc.getPropertyValue("file:content/digest"));
        String name = (String)((Object)doc.getPropertyValue("file:content/name"));
        String extension = FilenameUtils.getExtension((String)name);
        File originalFile = File.createTempFile("original", "." + extension);
        GetObjectRequest request = new GetObjectRequest(s3bm.getBucketName(), s3bm.getBucketPrefix() + digest);
        Download download = s3bm.getTransferManager().download(request, originalFile);
        try {
            download.waitForCompletion();
            log.debug((Object)("Download: " + download.getState().name() + " progress" + download.getProgress().getPercentTransferred()));
            return originalFile;
        }
        catch (AmazonClientException | InterruptedException e) {
            throw new NuxeoException("Get file failed: ");
        }
    }

    protected Blob convertBlobToPDF(BlobHolder bh) {
        try {
            return ((ConversionService)Framework.getService(ConversionService.class)).convertToMimeType("application/pdf", bh, Collections.emptyMap()).getBlob();
        }
        catch (Exception e) {
            log.error((Object)"Error converting to PDF", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String streamTextBlobToString(Blob blob) {
        try (InputStream inputStream = blob.getStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append(System.lineSeparator());
                }
                string = stringBuilder.toString();
            }
            return string;
        }
        catch (IOException e) {
            log.error((Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String streamPDFBlobToString(Blob blob) {
        try (InputStream inputStream = blob.getStream();){
            String string;
            block14: {
                PDDocument document = PDDocument.load((InputStream)inputStream);
                try {
                    PDFTextStripper pdfStripper = new PDFTextStripper();
                    string = pdfStripper.getText(document);
                    if (document == null) break block14;
                }
                catch (Throwable throwable) {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                document.close();
            }
            return string;
        }
        catch (IOException e) {
            log.error((Object)e);
            return null;
        }
    }

    protected void streamPDFBlobAndSubmitForProcessing(Blob blob, String docId) {
        BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
        String commandId = bulkService.submit(new BulkCommand.Builder("summaryStream", "ignored", "system").param("docId", (Serializable)((Object)docId)).useExternalScroller().build());
        ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore("kv").put(docId, commandId);
        try (InputStream inputStream = blob.getStream();
             PDDocument document = PDDocument.load((InputStream)inputStream);){
            PDFTextStripperByArea stripper = new PDFTextStripperByArea();
            stripper.setSortByPosition(true);
            PDFTextStripper textStripper = new PDFTextStripper();
            int noPages = document.getNumberOfPages();
            ArrayList<String> text = new ArrayList<String>();
            for (int currentPage = 1; currentPage <= document.getNumberOfPages(); ++currentPage) {
                textStripper.setStartPage(currentPage);
                textStripper.setEndPage(currentPage);
                String pageText = textStripper.getText(document);
                pageText = this.removeRepetitiveCharacters(pageText);
                if (!StringUtils.isEmpty((CharSequence)pageText)) {
                    text.add(this.formatPageTextForProcessing(docId, currentPage, pageText));
                }
                if (text.size() != Integer.parseInt(Framework.getProperty((String)"summaryStreams.bucketSize", (String)"5"))) continue;
                bulkService.appendExternalBucket(new BulkBucket(commandId, text));
                text.clear();
            }
            if (!text.isEmpty()) {
                bulkService.appendExternalBucket(new BulkBucket(commandId, text));
            }
            document.close();
            bulkService.completeExternalScroll(commandId, (long)noPages);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected String removeRepetitiveCharacters(String text) {
        return text.replaceAll("(\\s*(.)\\s*)\\1+", "$1");
    }

    private String getApiUrl() {
        return Framework.getProperty((String)"summary.extraction.openai.url", (String)"https://api.openai.com/v1/completions");
    }

    protected void disableListeners(DocumentModel doc) {
        doc.putContextData("disableSummaryListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableExtractSummaryListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        doc.putContextData("disableBinaryMetadataListener", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutomaticVersioning", (Serializable)Boolean.TRUE);
        doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        doc.putContextData("disablePictureViewsGenerationListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableThumbnailComputation", (Serializable)Boolean.TRUE);
        doc.putContextData("disableMetadataExtractorListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableBlobComplianceListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableStoryDocumentListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableInheritLicenseListener", (Serializable)Boolean.TRUE);
    }
}

