/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.blob.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.EncryptedPutObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectLockLegalHold;
import com.amazonaws.services.s3.model.ObjectLockLegalHoldStatus;
import com.amazonaws.services.s3.model.ObjectLockRetention;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SSEAlgorithm;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SetObjectLegalHoldRequest;
import com.amazonaws.services.s3.model.SetObjectRetentionRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.model.CopyResult;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.utils.RFC2231;
import org.nuxeo.ecm.blob.s3.S3BlobStoreConfiguration;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.blob.AbstractBlobGarbageCollector;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.ByteRange;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.KeyStrategyDigest;
import org.nuxeo.ecm.core.blob.KeyStrategyDocId;
import org.nuxeo.ecm.core.blob.PathStrategy;
import org.nuxeo.ecm.core.blob.PathStrategyFlat;
import org.nuxeo.ecm.core.blob.PathStrategySubDirs;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;

public class S3BlobStore
extends AbstractBlobStore {
    private static final Logger log = LogManager.getLogger(S3BlobStore.class);
    private static final Logger logs3dl = LogManager.getLogger((String)"S3_Download");
    protected static final String USER_METADATA_USERNAME = "username";
    protected final S3BlobStoreConfiguration config;
    protected final AmazonS3 amazonS3;
    protected final String bucketName;
    protected final String bucketPrefix;
    protected final PathStrategy pathStrategy;
    protected final boolean pathSeparatorIsBackslash;
    protected final boolean allowByteRange;
    protected final boolean useVersion;
    protected volatile Boolean useAsyncDigest;
    protected final BinaryGarbageCollector gc;

    @Deprecated
    public S3BlobStore(String name, S3BlobStoreConfiguration config, KeyStrategy keyStrategy) {
        this(null, name, config, keyStrategy);
    }

    public S3BlobStore(String blobProviderId, String name, S3BlobStoreConfiguration config, KeyStrategy keyStrategy) {
        super(blobProviderId, name, keyStrategy);
        this.config = config;
        this.amazonS3 = config.amazonS3;
        this.bucketName = config.bucketName;
        this.bucketPrefix = config.bucketPrefix;
        Path p = Paths.get(this.bucketPrefix, new String[0]);
        int subDirsDepth = config.getSubDirsDepth();
        this.pathStrategy = subDirsDepth == 0 ? new PathStrategyFlat(p) : new PathStrategySubDirs(p, subDirsDepth);
        this.pathSeparatorIsBackslash = FileSystems.getDefault().getSeparator().equals("\\");
        this.allowByteRange = config.getBooleanProperty("allowByteRange");
        this.useVersion = keyStrategy instanceof KeyStrategyDocId && this.isBucketVersioningEnabled();
        this.gc = new S3BlobGarbageCollector();
    }

    public S3BlobStore getS3BinaryManager() {
        return this;
    }

    protected static boolean isMissingKey(AmazonServiceException e) {
        return e.getStatusCode() == 404 || "NoSuchKey".equals(e.getErrorCode()) || "Not Found".equals(e.getMessage());
    }

    protected static boolean isNotImplemented(AmazonServiceException e) {
        return e.getStatusCode() == 501 || "NotImplemented".equals(e.getErrorCode());
    }

    protected boolean isBucketVersioningEnabled() {
        try {
            BucketVersioningConfiguration v = this.amazonS3.getBucketVersioningConfiguration(this.bucketName);
            return v.getStatus().equals("Enabled");
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isNotImplemented(e)) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> this.bucketName;
                supplierArray[1] = () -> ((AmazonServiceException)e).getMessage();
                log.warn("Versioning not implemented for bucket: {}: {}", supplierArray);
                log.debug((Object)e, (Throwable)e);
                return false;
            }
            throw e;
        }
    }

    public boolean hasVersioning() {
        return this.useVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useAsyncDigest() {
        if (this.useAsyncDigest == null) {
            S3BlobStore s3BlobStore = this;
            synchronized (s3BlobStore) {
                if (this.useAsyncDigest == null) {
                    this.useAsyncDigest = this.config.digestConfiguration.digestAsync && this.supportsAsyncDigest();
                }
            }
        }
        return this.useAsyncDigest;
    }

    protected boolean supportsAsyncDigest() {
        RepositoryService repositoryService = (RepositoryService)Framework.getService(RepositoryService.class);
        return repositoryService.getRepositoryNames().stream().map(arg_0 -> ((RepositoryService)repositoryService).getRepository(arg_0)).allMatch(this::supportsAsyncDigest);
    }

    protected boolean supportsAsyncDigest(Repository repository) {
        return repository.hasCapability("queryBlobKeys");
    }

    protected String bucketKey(String key) {
        if (this.config.getSubDirsDepth() == 0) {
            return this.bucketPrefix + key;
        }
        String path = this.pathStrategy.getPathForKey(key).toString();
        if (this.pathSeparatorIsBackslash) {
            path = path.replace("\\", "/");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String writeBlobGeneric(BlobWriteContext blobWriteContext) throws IOException {
        Path tmp = null;
        try {
            String fileTraceSource;
            Path file;
            BlobContext blobContext = blobWriteContext.blobContext;
            Path blobWriteContextFile = blobWriteContext.getFile();
            if (blobWriteContextFile != null) {
                file = blobWriteContextFile;
                fileTraceSource = "Nuxeo";
            } else {
                File blobFile = blobContext.blob.getFile();
                if (blobFile != null) {
                    if (blobWriteContext.writeObserver != null) {
                        this.transfer(blobWriteContext, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                    }
                    file = blobFile.toPath();
                    fileTraceSource = "Nuxeo";
                } else {
                    tmp = Files.createTempFile("bin_", ".tmp", new FileAttribute[0]);
                    this.logTrace(null, "->", "tmp", "write");
                    this.logTrace("hnote right: " + tmp.getFileName());
                    this.transfer(blobWriteContext, tmp);
                    file = tmp;
                    fileTraceSource = "tmp";
                }
            }
            String key = blobWriteContext.getKey();
            if (key == null) {
                throw new NuxeoException("Missing key");
            }
            if (key.indexOf(64) >= 0) {
                throw new NuxeoException("Invalid key '" + key + "', it contains the version separator '@'");
            }
            String versionId = this.writeFile(key, file, blobContext, fileTraceSource);
            String string = versionId == null ? key : key + "@" + versionId;
            return string;
        }
        finally {
            if (tmp != null) {
                try {
                    this.logTrace("tmp", "-->", "tmp", "delete");
                    this.logTrace("hnote right: " + tmp.getFileName());
                    Files.delete(tmp);
                }
                catch (IOException e) {
                    log.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected String writeFile(String key, Path file, BlobContext blobContext, String fileTraceSource) throws IOException {
        EncryptedPutObjectRequest putObjectRequest;
        String bucketKey = this.bucketKey(key);
        long t0 = 0L;
        if (log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
            log.debug("Writing s3://" + this.bucketName + "/" + bucketKey);
        }
        if (this.getKeyStrategy().useDeDuplication() && this.bucketKeyExists(bucketKey)) {
            return null;
        }
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (this.config.useClientSideEncryption) {
            putObjectRequest = new EncryptedPutObjectRequest(this.bucketName, bucketKey, file.toFile());
        } else {
            putObjectRequest = new PutObjectRequest(this.bucketName, bucketKey, file.toFile());
            if (this.config.useServerSideEncryption) {
                if (StringUtils.isNotBlank((CharSequence)this.config.serverSideKMSKeyID)) {
                    SSEAwsKeyManagementParams params = new SSEAwsKeyManagementParams(this.config.serverSideKMSKeyID);
                    putObjectRequest.setSSEAwsKeyManagementParams(params);
                } else {
                    objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                }
            }
        }
        this.setMetadata(objectMetadata, blobContext);
        putObjectRequest.setMetadata(objectMetadata);
        this.logTrace(fileTraceSource, "->", null, "write " + Files.size(file) + " bytes");
        this.logTrace("hnote right: " + bucketKey);
        Upload upload = this.config.transferManager.upload((PutObjectRequest)putObjectRequest);
        try {
            String versionId;
            UploadResult uploadResult = upload.waitForUploadResult();
            String string = versionId = this.useVersion ? uploadResult.getVersionId() : null;
            if (log.isDebugEnabled()) {
                long dtms = System.currentTimeMillis() - t0;
                log.debug("Wrote s3://" + this.bucketName + "/" + bucketKey + " in " + dtms + "ms");
            }
            if (versionId != null) {
                this.logTrace("<--", "v=" + versionId);
            }
            return versionId;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
        catch (SdkBaseException e) {
            throw new NuxeoException("Failed to write blob: " + key, (Throwable)e);
        }
    }

    protected void setMetadata(ObjectMetadata objectMetadata, BlobContext blobContext) {
        String username;
        NuxeoPrincipal principal;
        if (blobContext != null) {
            Blob blob = blobContext.blob;
            String filename = blob.getFilename();
            if (filename != null) {
                String contentDisposition = RFC2231.encodeContentDisposition((String)filename, (boolean)false, null);
                objectMetadata.setContentDisposition(contentDisposition);
            }
            String contentType = DownloadHelper.getContentTypeHeader((Blob)blob);
            objectMetadata.setContentType(contentType);
        }
        if (this.config.metadataAddUsername && (principal = NuxeoPrincipal.getCurrent()) != null && !(principal instanceof SystemPrincipal) && (username = principal.getActingUser()) != null) {
            Map<String, String> userMetadata = Collections.singletonMap(USER_METADATA_USERNAME, username);
            objectMetadata.setUserMetadata(userMetadata);
        }
    }

    public BlobStore.OptionalOrUnknown<Path> getFile(String key) {
        return BlobStore.OptionalOrUnknown.unknown();
    }

    public BlobStore.OptionalOrUnknown<InputStream> getStream(String key) throws IOException {
        return BlobStore.OptionalOrUnknown.unknown();
    }

    public boolean exists(String key) {
        return this.bucketKeyExists(this.bucketKey(key));
    }

    protected boolean bucketKeyExists(String bucketKey) {
        this.logTrace("-->", "doesObjectExist");
        this.logTrace("hnote right: " + bucketKey);
        boolean exists = this.amazonS3.doesObjectExist(this.bucketName, bucketKey);
        if (exists) {
            log.debug("Blob s3://{}/{} already exists", (Object)this.bucketName, (Object)bucketKey);
            this.logTrace("<--", "exists");
        } else {
            this.logTrace("<--", "missing");
        }
        return exists;
    }

    protected long lengthOfBlob(String key) {
        String bucketKey = this.bucketKey(key);
        try {
            this.logTrace("-->", "getObjectMetadata");
            this.logTrace("hnote right: " + bucketKey);
            ObjectMetadata metadata = this.amazonS3.getObjectMetadata(this.bucketName, bucketKey);
            long length = metadata.getContentLength();
            this.logTrace("<--", "exists (" + length + " bytes)");
            return length;
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                this.logTrace("<--", "missing");
            } else {
                log.warn("Cannot get length of: s3://" + this.bucketName + "/" + bucketKey, (Throwable)e);
            }
            return -1L;
        }
    }

    public void clear() {
        this.logTrace("group ClearBucket");
        ObjectListing list = null;
        long n = 0L;
        do {
            if (list == null) {
                this.logTrace("->", "listObjects");
                ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(this.bucketPrefix);
                if (this.config.getSubDirsDepth() == 0) {
                    listObjectsRequest.setDelimiter("/");
                }
                list = this.amazonS3.listObjects(listObjectsRequest);
            } else {
                list = this.amazonS3.listNextBatchOfObjects(list);
            }
            for (S3ObjectSummary summary : list.getObjectSummaries()) {
                this.amazonS3.deleteObject(this.bucketName, summary.getKey());
                ++n;
            }
        } while (list.isTruncated());
        if (n > 0L) {
            this.logTrace("loop " + n + " objects");
            this.logTrace("->", "deleteObject");
            this.logTrace("end");
        }
        VersionListing vlist = null;
        long vn = 0L;
        do {
            if (vlist == null) {
                this.logTrace("->", "listVersions");
                ListVersionsRequest listVersionsRequest = new ListVersionsRequest().withBucketName(this.bucketName).withPrefix(this.bucketPrefix);
                if (this.config.getSubDirsDepth() == 0) {
                    listVersionsRequest.setDelimiter("/");
                }
                vlist = this.amazonS3.listVersions(listVersionsRequest);
            } else {
                vlist = this.amazonS3.listNextBatchOfVersions(vlist);
            }
            for (S3VersionSummary vsummary : vlist.getVersionSummaries()) {
                this.amazonS3.deleteVersion(this.bucketName, vsummary.getKey(), vsummary.getVersionId());
                ++vn;
            }
        } while (vlist.isTruncated());
        if (vn > 0L) {
            this.logTrace("loop " + vn + " versions");
            this.logTrace("->", "deleteVersion");
            this.logTrace("end");
        }
        this.logTrace("end");
    }

    public boolean readBlob(String key, Path dest) throws IOException {
        String versionId;
        String objectKey;
        int seppos;
        ByteRange byteRange;
        if (this.allowByteRange) {
            MutableObject keyHolder = new MutableObject((Object)key);
            byteRange = S3BlobStore.getByteRangeFromKey((MutableObject)keyHolder);
            key = (String)keyHolder.getValue();
        } else {
            byteRange = null;
        }
        key = this.getBlobKeyReplacement(key);
        if (this.useVersion && (seppos = key.indexOf(64)) > 0) {
            objectKey = key.substring(0, seppos);
            versionId = key.substring(seppos + 1);
        } else {
            objectKey = key;
            versionId = null;
        }
        String bucketKey = this.bucketKey(objectKey);
        String debugKey = bucketKey + (String)(versionId == null ? "" : "@" + versionId);
        String debugObject = "s3://" + this.bucketName + "/" + debugKey;
        try {
            log.debug("Reading {}", (Object)debugObject);
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, bucketKey, versionId);
            if (byteRange != null) {
                getObjectRequest.setRange(byteRange.getStart(), byteRange.getEnd());
            }
            long t0 = System.currentTimeMillis();
            Download download = this.config.transferManager.download(getObjectRequest, dest.toFile());
            download.waitForCompletion();
            long dtms = System.currentTimeMillis() - t0;
            this.logTrace("<-", "read " + Files.size(dest) + " bytes");
            this.logTrace("hnote right: " + debugKey);
            log.debug("Read {} in {} ms", (Object)debugObject, (Object)dtms);
            if (logs3dl.isDebugEnabled()) {
                String message = String.format("Read %s (%d bytes) in %.3f s", debugObject, Files.size(dest), (double)dtms / 1000.0);
                logs3dl.debug(message, (Throwable)new Exception("DEBUGGING STACK TRACE"));
            }
            return true;
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                this.logTrace("<--", "missing");
                this.logTrace("hnote right: " + debugKey);
                log.debug("Blob {} does not exist", (Object)debugObject);
                return false;
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
    }

    public boolean copyBlobIsOptimized(BlobStore sourceStore) {
        return sourceStore.unwrap() instanceof S3BlobStore;
    }

    public String copyOrMoveBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        BlobStore unwrappedSourceStore = sourceStore.unwrap();
        if (unwrappedSourceStore instanceof S3BlobStore) {
            S3BlobStore sourceS3BlobStore = (S3BlobStore)unwrappedSourceStore;
            try {
                String returnedKey = this.copyOrMoveBlob(key, sourceS3BlobStore, sourceKey, atomicMove);
                if (returnedKey != null) {
                    return returnedKey;
                }
            }
            catch (AmazonServiceException e) {
                if (S3BlobStore.isMissingKey(e)) {
                    this.logTrace("<--", "missing");
                    return null;
                }
                throw new IOException(e);
            }
        }
        return this.copyOrMoveBlobGeneric(key, sourceStore, sourceKey, atomicMove);
    }

    @Deprecated
    protected boolean copyBlob(String key, S3BlobStore sourceBlobStore, String sourceKey, boolean move) throws AmazonServiceException {
        return this.copyOrMoveBlob(key, sourceBlobStore, sourceKey, move) != null;
    }

    protected String copyOrMoveBlob(String key, S3BlobStore sourceBlobStore, String sourceKey, boolean move) throws AmazonServiceException {
        String sourceVersionId;
        String sourceObjectKey;
        int seppos = (sourceKey = this.getBlobKeyReplacement(sourceKey)).indexOf(64);
        if (seppos < 0) {
            sourceObjectKey = sourceKey;
            sourceVersionId = null;
        } else {
            sourceObjectKey = sourceKey.substring(0, seppos);
            sourceVersionId = sourceKey.substring(seppos + 1);
        }
        String sourceBucketName = sourceBlobStore.bucketName;
        String sourceBucketKey = sourceBlobStore.bucketKey(sourceObjectKey);
        if (key == null) {
            String digest;
            if (this.keyStrategy instanceof KeyStrategyDigest && ((KeyStrategyDigest)this.keyStrategy).digestAlgorithm.equals("MD5") && (digest = sourceBlobStore.getMD5DigestFromETag(sourceBucketKey)) != null) {
                key = digest;
            } else {
                key = this.randomString();
                this.notifyAsyncDigest(key);
            }
        }
        String bucketKey = this.bucketKey(key);
        long t0 = 0L;
        if (log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
            log.debug("Copying s3://" + sourceBucketName + "/" + sourceBucketKey + " to s3://" + this.bucketName + "/" + bucketKey);
        }
        if (this.getKeyStrategy().useDeDuplication() && this.bucketKeyExists(bucketKey)) {
            return key;
        }
        try {
            String versionId = this.copyOrMoveBlob(sourceBlobStore.config, sourceBucketKey, sourceVersionId, this.config, bucketKey, move);
            if (log.isDebugEnabled()) {
                long dtms = System.currentTimeMillis() - t0;
                log.debug("Copied s3://" + sourceBucketName + "/" + sourceBucketKey + " to s3://" + this.bucketName + "/" + bucketKey + " in " + dtms + "ms");
            }
            return versionId == null ? key : key + "@" + versionId;
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                throw e;
            }
            this.logTrace("<--", "ERROR");
            String message = "Direct copy failed from s3://" + sourceBucketName + "/" + sourceBucketKey + " to s3://" + this.bucketName + "/" + bucketKey;
            log.warn(message + ", falling back to slow copy: " + e.getMessage());
            log.debug(message, (Throwable)e);
            return null;
        }
    }

    protected String getMD5DigestFromETag(String bucketKey) {
        ObjectMetadata metadata = this.amazonS3.getObjectMetadata(this.bucketName, bucketKey);
        String eTag = metadata.getETag();
        if (eTag.contains("-")) {
            return null;
        }
        if (SSEAlgorithm.KMS.getAlgorithm().equals(metadata.getSSEAlgorithm())) {
            return null;
        }
        return eTag;
    }

    @Deprecated
    protected void copyBlob(S3BlobStoreConfiguration sourceConfig, String sourceKey, S3BlobStoreConfiguration destinationConfig, String destinationKey, boolean move) {
        this.copyOrMoveBlob(sourceConfig, sourceKey, null, destinationConfig, destinationKey, move);
    }

    protected String copyOrMoveBlob(S3BlobStoreConfiguration sourceConfig, String sourceKey, String sourceVersionId, S3BlobStoreConfiguration destinationConfig, String destinationKey, boolean move) {
        CopyResult copyResult;
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(sourceConfig.bucketName, sourceKey, sourceVersionId, destinationConfig.bucketName, destinationKey);
        if (destinationConfig.useServerSideEncryption) {
            if (StringUtils.isNotBlank((CharSequence)destinationConfig.serverSideKMSKeyID)) {
                SSEAwsKeyManagementParams params = new SSEAwsKeyManagementParams(destinationConfig.serverSideKMSKeyID);
                copyObjectRequest.setSSEAwsKeyManagementParams(params);
            } else {
                ObjectMetadata newObjectMetadata = new ObjectMetadata();
                newObjectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                copyObjectRequest.setNewObjectMetadata(newObjectMetadata);
            }
        }
        this.logTrace("->", "copyObject");
        this.logTrace("hnote right: " + sourceKey + (String)(sourceVersionId == null ? "" : "@" + sourceVersionId) + " to " + destinationKey);
        Copy copy = destinationConfig.transferManager.copy(copyObjectRequest, sourceConfig.amazonS3, null);
        try {
            copyResult = copy.waitForCopyResult();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
        String versionId = this.useVersion ? copyResult.getVersionId() : null;
        this.logTrace("<--", "copied");
        if (versionId != null) {
            this.logTrace("hnote right: v=" + versionId);
        }
        if (move) {
            this.logTrace("->", "deleteObject");
            this.logTrace("hnote right: " + sourceKey);
            this.amazonS3.deleteObject(sourceConfig.bucketName, sourceKey);
        }
        return versionId;
    }

    @Deprecated
    protected boolean copyBlobGeneric(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        return this.copyOrMoveBlobGeneric(key, sourceStore, sourceKey, atomicMove) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String copyOrMoveBlobGeneric(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        Path tmp = null;
        try {
            String fileTraceSource;
            Path file;
            BlobStore.OptionalOrUnknown fileOpt = sourceStore.getFile(sourceKey);
            if (fileOpt.isPresent()) {
                file = (Path)fileOpt.get();
                fileTraceSource = sourceStore.getName();
            } else {
                tmp = Files.createTempFile("bin_", ".tmp", new FileAttribute[0]);
                this.logTrace(null, "->", "tmp", "write");
                this.logTrace("hnote right: " + tmp.getFileName());
                boolean found = sourceStore.readBlob(sourceKey, tmp);
                if (!found) {
                    String string = null;
                    return string;
                }
                file = tmp;
                fileTraceSource = "tmp";
            }
            String versionId = this.writeFile(key, file, null, fileTraceSource);
            if (atomicMove) {
                sourceStore.deleteBlob(sourceKey);
            }
            String string = versionId == null ? key : key + "@" + versionId;
            return string;
        }
        finally {
            if (tmp != null) {
                try {
                    this.logTrace("tmp", "-->", "tmp", "delete");
                    this.logTrace("hnote right: " + tmp.getFileName());
                    Files.delete(tmp);
                }
                catch (IOException e) {
                    log.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    public void writeBlobProperties(BlobUpdateContext blobUpdateContext) throws IOException {
        String versionId;
        String objectKey;
        String key = blobUpdateContext.key;
        int seppos = (key = this.getBlobKeyReplacement(key)).indexOf(64);
        if (seppos < 0) {
            objectKey = key;
            versionId = null;
        } else {
            objectKey = key.substring(0, seppos);
            versionId = key.substring(seppos + 1);
        }
        String bucketKey = this.bucketKey(objectKey);
        try {
            if (this.config.s3RetentionEnabled) {
                SetObjectLegalHoldRequest request;
                if (blobUpdateContext.updateRetainUntil != null) {
                    if (versionId == null) {
                        throw new IOException("Cannot set retention on non-versioned blob");
                    }
                    Calendar retainUntil = blobUpdateContext.updateRetainUntil.retainUntil;
                    Date retainUntilDate = retainUntil == null ? null : retainUntil.getTime();
                    ObjectLockRetention retention = new ObjectLockRetention();
                    retention.withMode(this.config.retentionMode).withRetainUntilDate(retainUntilDate);
                    request = new SetObjectRetentionRequest();
                    request.withBucketName(this.bucketName).withKey(bucketKey).withVersionId(versionId).withRetention(retention);
                    this.logTrace("->", "setObjectRetention");
                    this.logTrace("hnote right: " + bucketKey + "@" + versionId);
                    this.logTrace("rnote right: " + (retainUntil == null ? "null" : retainUntil.toInstant().toString()));
                    this.amazonS3.setObjectRetention((SetObjectRetentionRequest)request);
                }
                if (blobUpdateContext.updateLegalHold != null) {
                    if (versionId == null) {
                        throw new IOException("Cannot set legal hold on non-versioned blob");
                    }
                    boolean hold = blobUpdateContext.updateLegalHold.hold;
                    ObjectLockLegalHoldStatus status = hold ? ObjectLockLegalHoldStatus.ON : ObjectLockLegalHoldStatus.OFF;
                    ObjectLockLegalHold legalHold = new ObjectLockLegalHold().withStatus(status);
                    request = new SetObjectLegalHoldRequest();
                    request.withBucketName(this.bucketName).withKey(bucketKey).withVersionId(versionId).withLegalHold(legalHold);
                    this.logTrace("->", "setObjectLegalHold");
                    this.logTrace("hnote right: " + bucketKey + "@" + versionId);
                    this.logTrace("rnote right: " + status.toString());
                    this.amazonS3.setObjectLegalHold(request);
                }
            }
            if (blobUpdateContext.coldStorageClass != null) {
                StorageClass storageClass = blobUpdateContext.coldStorageClass.inColdStorage ? StorageClass.Glacier : StorageClass.Standard;
                CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucketName, bucketKey, this.bucketName, bucketKey).withSourceVersionId(versionId).withStorageClass(storageClass);
                this.logTrace("->", "updateStorageClass");
                this.logTrace("hnote right: " + bucketKey + "@" + versionId);
                this.logTrace("rnote right: " + storageClass);
                this.amazonS3.copyObject(copyObjectRequest);
            }
            if (blobUpdateContext.restoreForDuration != null) {
                Duration duration = blobUpdateContext.restoreForDuration.duration;
                int days = (int)duration.plusDays(1L).minusSeconds(1L).toDays();
                RestoreObjectRequest request = new RestoreObjectRequest(this.bucketName, bucketKey, days).withVersionId(versionId);
                this.amazonS3.restoreObjectV2(request);
            }
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                this.logTrace("<--", "missing");
                if (log.isDebugEnabled()) {
                    log.debug("Blob s3://" + this.bucketName + "/" + bucketKey + " does not exist");
                }
            }
            throw new IOException(e);
        }
    }

    public void deleteBlob(String key) {
        String versionId;
        String objectKey;
        int seppos = key.indexOf(64);
        if (seppos < 0) {
            objectKey = key;
            versionId = null;
        } else {
            objectKey = key.substring(0, seppos);
            versionId = key.substring(seppos + 1);
        }
        String bucketKey = this.bucketKey(objectKey);
        try {
            if (versionId == null) {
                this.logTrace("->", "deleteObject");
                this.logTrace("hnote right: " + bucketKey);
                this.amazonS3.deleteObject(this.bucketName, bucketKey);
            } else {
                this.logTrace("->", "deleteVersion");
                this.logTrace("hnote right: " + bucketKey + "@" + versionId);
                this.amazonS3.deleteVersion(this.bucketName, bucketKey, versionId);
            }
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                this.logTrace("<--", "missing");
            }
            log.warn("Cannot delete: s3://" + this.bucketName + "/" + bucketKey + "@" + versionId, (Throwable)e);
        }
    }

    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.gc;
    }

    public class S3BlobGarbageCollector
    extends AbstractBlobGarbageCollector {
        protected static final int WARN_OBJECTS_THRESHOLD = 100000;

        public String getId() {
            return "s3:" + S3BlobStore.this.bucketName + "/" + S3BlobStore.this.bucketPrefix;
        }

        public void computeToDelete() {
            boolean useDeDuplication = S3BlobStore.this.keyStrategy.useDeDuplication();
            this.toDelete = new HashSet();
            ObjectListing list = null;
            int prefixLength = S3BlobStore.this.bucketPrefix.length();
            S3BlobStore.this.logTrace("->", "listObjects on " + this.getId());
            do {
                if (list == null) {
                    ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(S3BlobStore.this.bucketName).withPrefix(S3BlobStore.this.bucketPrefix);
                    if (S3BlobStore.this.config.getSubDirsDepth() == 0) {
                        listObjectsRequest.setDelimiter("/");
                    }
                    list = S3BlobStore.this.amazonS3.listObjects(listObjectsRequest);
                } else {
                    list = S3BlobStore.this.amazonS3.listNextBatchOfObjects(list);
                }
                for (S3ObjectSummary summary : list.getObjectSummaries()) {
                    String path = summary.getKey().substring(prefixLength);
                    String key = S3BlobStore.this.config.getSubDirsDepth() == 0 ? path : S3BlobStore.this.pathStrategy.getKeyForPath(path);
                    if (key == null || useDeDuplication && !((KeyStrategyDigest)S3BlobStore.this.keyStrategy).isValidDigest(key)) continue;
                    long length = summary.getSize();
                    this.status.sizeBinaries += length;
                    ++this.status.numBinaries;
                    this.toDelete.add(key);
                    if (this.toDelete.size() % 100000 != 0) continue;
                    log.warn("Listing {} in progress, {} objects ...", (Object)this.getId(), (Object)this.toDelete.size());
                }
            } while (list.isTruncated());
            S3BlobStore.this.logTrace("<--", this.status.numBinaries + " objects");
            if (this.toDelete.size() >= 100000) {
                log.warn("Listing {} completed, {} objects.", (Object)this.getId(), (Object)this.toDelete.size());
            }
        }

        public void mark(String key) {
            int seppos = key.indexOf(64);
            if (seppos > 0) {
                key = key.substring(0, seppos);
            }
            this.toDelete.remove(key);
        }

        public void removeUnmarkedBlobsAndUpdateStatus(boolean delete) {
            for (String key : this.toDelete) {
                long length = S3BlobStore.this.lengthOfBlob(key);
                if (length < 0L) continue;
                this.status.sizeBinariesGC += length;
                ++this.status.numBinariesGC;
                this.status.sizeBinaries -= length;
                --this.status.numBinaries;
                if (!delete) continue;
                S3BlobStore.this.deleteBlob(key);
            }
        }
    }
}

