/*
 * Decompiled with CFR 0.152.
 */
package io.maretha.summary.stream;

import io.maretha.summary.services.SummaryService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;

public class PageSummaryComputation
extends AbstractBulkComputation {
    private static final Log log = LogFactory.getLog(PageSummaryComputation.class);
    private SummaryService summaryService;
    private KeyValueStore kvStore;

    public PageSummaryComputation() {
        super("bulk/summaryStream");
    }

    protected void compute(CoreSession session, List<String> text, Map<String, Serializable> properties) {
        String patternString = "DOC(.*?)PAGE(.*?)TEXT(.*)";
        for (String string : text) {
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                String pageNo;
                String docId = matcher.group(1).trim();
                String textToSummarize = string.substring(String.format("DOC%sPAGE%sTEXT", docId, pageNo = matcher.group(2).trim()).length());
                if (StringUtils.isEmpty((CharSequence)textToSummarize) || textToSummarize.length() <= 10) continue;
                String response = this.getSummaryService().summarizeText(textToSummarize);
                if ("NOT PROCESSED, RETRYING".equals(response)) {
                    this.getSummaryService().saveStatus(response, docId);
                    throw new NuxeoException("Summary for doc: " + docId + ", page:" + pageNo + "  not processed");
                }
                this.getKVS().put(this.command.getId() + ":" + pageNo, response, 86400L);
                continue;
            }
            log.debug((Object)("Text" + text + " not a message to summarize, skipping"));
        }
    }

    private KeyValueStore getKVS() {
        if (this.kvStore == null) {
            this.kvStore = ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore("kv");
        }
        return this.kvStore;
    }

    private SummaryService getSummaryService() {
        if (this.summaryService == null) {
            this.summaryService = (SummaryService)Framework.getService(SummaryService.class);
        }
        return this.summaryService;
    }
}

