/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.aws.AWSConfigurationService;

public class NuxeoAWSCredentialsProvider
implements AWSCredentialsProvider {
    protected static final AWSCredentialsProvider INSTANCE = new NuxeoAWSCredentialsProvider();
    protected static final AWSCredentialsProvider DEFAULT = new DefaultAWSCredentialsProviderChain();
    protected final String id;

    public static AWSCredentialsProvider getInstance() {
        return INSTANCE;
    }

    public NuxeoAWSCredentialsProvider() {
        this(null);
    }

    public NuxeoAWSCredentialsProvider(String id) {
        this.id = id;
    }

    public AWSCredentials getCredentials() {
        AWSCredentials credentials;
        AWSConfigurationService service = (AWSConfigurationService)Framework.getService(AWSConfigurationService.class);
        if (service != null && (credentials = service.getAWSCredentials(this.id)) != null) {
            return credentials;
        }
        return DEFAULT.getCredentials();
    }

    public void refresh() {
        DEFAULT.refresh();
    }
}

