/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.io.IOException;
import java.text.ParseException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.FilterParserImpl;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.name.DefaultStringNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.nuxeo.ecm.directory.DirectoryException;

public class LDAPFilterMatcher {
    private final FilterParser parser = new FilterParserImpl();
    private Normalizer normalizer;

    LDAPFilterMatcher() {
    }

    public boolean match(Attributes attributes, String filter) throws DirectoryException {
        if (filter == null || "".equals(filter)) {
            return true;
        }
        try {
            ExprNode parsedFilter = this.parser.parse(filter);
            return this.recursiveMatch(attributes, parsedFilter);
        }
        catch (IOException | ParseException | DirectoryException e) {
            throw new DirectoryException("could not parse LDAP filter: " + filter, e);
        }
    }

    private boolean recursiveMatch(Attributes attributes, ExprNode filterElement) throws DirectoryException {
        if (filterElement instanceof PresenceNode) {
            return this.presenceMatch(attributes, (PresenceNode)filterElement);
        }
        if (filterElement instanceof SimpleNode) {
            return LDAPFilterMatcher.simpleMatch(attributes, (SimpleNode)filterElement);
        }
        if (filterElement instanceof SubstringNode) {
            return this.substringMatch(attributes, (SubstringNode)filterElement);
        }
        if (filterElement instanceof BranchNode) {
            return this.branchMatch(attributes, (BranchNode)filterElement);
        }
        throw new DirectoryException("unsupported filter element type: " + filterElement);
    }

    private boolean presenceMatch(Attributes attributes, PresenceNode presenceElement) {
        return attributes.get(presenceElement.getAttribute()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean simpleMatch(Attributes attributes, SimpleNode simpleElement) throws DirectoryException {
        Attribute attribute = attributes.get(simpleElement.getAttribute());
        if (attribute == null) {
            return false;
        }
        boolean isCaseSensitive = LDAPFilterMatcher.isCaseSensitiveMatch(attribute);
        try (NamingEnumeration<?> rawValues = attribute.getAll();){
            block11: {
                while (rawValues.hasMore()) {
                    String rawValue = rawValues.next().toString();
                    if (isCaseSensitive || !(simpleElement.getValue() instanceof String)) {
                        if (!simpleElement.getValue().equals(rawValue)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    String stringElementValue = (String)simpleElement.getValue();
                    if (!stringElementValue.equalsIgnoreCase(rawValue)) {
                        continue;
                    }
                    break block11;
                }
                return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (NamingException e) {
            throw new DirectoryException("could not retrieve value for attribute: " + simpleElement.getAttribute());
        }
    }

    protected static boolean isCaseSensitiveMatch(Attribute attribute) {
        return false;
    }

    protected static boolean isCaseSensitiveSubstringMatch(Attribute attribute) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean substringMatch(Attributes attributes, SubstringNode substringElement) throws DirectoryException {
        try {
            Attribute attribute = attributes.get(substringElement.getAttribute());
            if (attribute == null) {
                return false;
            }
            try (NamingEnumeration<?> rawValues = attribute.getAll();){
                String rawValue;
                Pattern pattern;
                do {
                    if (!rawValues.hasMore()) return false;
                    rawValue = rawValues.next().toString();
                    this.getNormalizer();
                    StringBuffer sb = new StringBuffer();
                    String initial = substringElement.getInitial();
                    String finalSegment = substringElement.getFinal();
                    if (initial != null && !initial.isEmpty()) {
                        sb.append(Pattern.quote((String)this.normalizer.normalize((Object)initial)));
                    }
                    sb.append(".*");
                    for (Object segment : substringElement.getAny()) {
                        if (!(segment instanceof String)) continue;
                        sb.append(Pattern.quote((String)this.normalizer.normalize(segment)));
                        sb.append(".*");
                    }
                    if (finalSegment != null && !finalSegment.isEmpty()) {
                        sb.append(Pattern.quote((String)this.normalizer.normalize((Object)finalSegment)));
                    }
                    try {
                        if (LDAPFilterMatcher.isCaseSensitiveSubstringMatch(attribute)) {
                            pattern = Pattern.compile(sb.toString());
                            continue;
                        }
                        pattern = Pattern.compile(sb.toString(), 2);
                    }
                    catch (PatternSyntaxException e) {
                        throw new DirectoryException("could not build regexp for substring: " + substringElement.toString());
                    }
                } while (!pattern.matcher(rawValue).matches());
                boolean bl = true;
                return bl;
            }
        }
        catch (NamingException e1) {
            throw new DirectoryException("could not retrieve value for attribute: " + substringElement.getAttribute());
        }
    }

    private Normalizer getNormalizer() {
        if (this.normalizer == null) {
            this.normalizer = new DefaultStringNormalizer();
        }
        return this.normalizer;
    }

    private boolean branchMatch(Attributes attributes, BranchNode branchElement) throws DirectoryException {
        if (branchElement.isConjunction()) {
            for (ExprNode child : branchElement.getChildren()) {
                if (this.recursiveMatch(attributes, child)) continue;
                return false;
            }
            return true;
        }
        if (branchElement.isDisjunction()) {
            for (ExprNode child : branchElement.getChildren()) {
                if (!this.recursiveMatch(attributes, child)) continue;
                return true;
            }
            return false;
        }
        if (branchElement.isNegation()) {
            return !this.recursiveMatch(attributes, branchElement.getChild());
        }
        throw new DirectoryException("unsupported branching filter element type: " + branchElement.toString());
    }
}

