/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.ldap.ContextProvider;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryFactory;
import org.nuxeo.ecm.directory.ldap.LDAPDynamicReferenceDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPReference;
import org.nuxeo.ecm.directory.ldap.LDAPServerDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.runtime.api.Framework;

public class LDAPDirectory
extends AbstractDirectory {
    private static final Log log = LogFactory.getLog(LDAPDirectory.class);
    public static final String DN_SPECIAL_ATTRIBUTE_KEY = "dn";
    protected Properties contextProperties;
    protected volatile SearchControls searchControls;
    protected final LDAPDirectoryFactory factory;
    protected String baseFilter;
    protected ContextProvider testServer;

    public LDAPDirectory(LDAPDirectoryDescriptor descriptor) {
        super((BaseDirectoryDescriptor)descriptor, LDAPReference.class);
        if (StringUtils.isEmpty((String)descriptor.getSearchBaseDn())) {
            throw new DirectoryException("searchBaseDn configuration is missing for directory " + this.getName());
        }
        this.factory = (LDAPDirectoryFactory)((Object)Framework.getService(LDAPDirectoryFactory.class));
    }

    public LDAPDirectoryDescriptor getDescriptor() {
        return (LDAPDirectoryDescriptor)this.descriptor;
    }

    public List<Reference> getReferences(String referenceFieldName) {
        this.initLDAPConfigIfNeeded();
        return (List)this.references.get(referenceFieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initLDAPConfigIfNeeded() {
        if (this.searchControls == null) {
            LDAPDirectory lDAPDirectory = this;
            synchronized (lDAPDirectory) {
                if (this.searchControls == null) {
                    this.initLDAPConfig();
                }
            }
        }
    }

    protected void initLDAPConfig() {
        LDAPDirectoryDescriptor ldapDirectoryDesc = this.getDescriptor();
        this.initSchemaFieldMap();
        this.fieldMapper = new DirectoryFieldMapper(ldapDirectoryDesc.fieldMapping);
        this.contextProperties = this.computeContextProperties();
        this.baseFilter = ldapDirectoryDesc.getAggregatedSearchFilter();
        this.addReferences(ldapDirectoryDesc.getLdapReferences());
        this.searchControls = this.computeSearchControls();
        log.debug((Object)String.format("initialized LDAP directory %s with fields [%s] and references [%s]", this.getName(), StringUtils.join((Object[])this.getSchemaFieldMap().keySet().toArray(), (String)", "), StringUtils.join((Object[])this.references.keySet().toArray(), (String)", ")));
    }

    protected Properties computeContextProperties() throws DirectoryException {
        String bindDn;
        LDAPDirectoryDescriptor ldapDirectoryDesc = this.getDescriptor();
        Properties props = new Properties();
        LDAPServerDescriptor serverConfig = this.getServer();
        if (null == serverConfig) {
            throw new DirectoryException("LDAP server configuration not found: " + ldapDirectoryDesc.getServerName());
        }
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String ldapUrls = serverConfig.getLdapUrls();
        if (ldapUrls == null) {
            throw new DirectoryException("Server LDAP URL configuration is missing for directory " + this.getName());
        }
        props.put("java.naming.provider.url", ldapUrls);
        if (!this.getDescriptor().getFollowReferrals()) {
            props.put("java.naming.referral", "ignore");
        } else {
            props.put("java.naming.referral", "follow");
        }
        if (serverConfig.getConnectionTimeout() > -1) {
            if (!serverConfig.useSsl()) {
                props.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(serverConfig.getConnectionTimeout()));
            } else {
                log.warn((Object)"SSL connections do not operate correctly when used with the connection timeout parameter, disabling timout");
            }
        }
        if ((bindDn = serverConfig.getBindDn()) != null) {
            props.put("java.naming.security.principal", bindDn);
            props.put("java.naming.security.credentials", serverConfig.getBindPassword());
        }
        if (serverConfig.isPoolingEnabled()) {
            props.put("com.sun.jndi.ldap.connect.pool", "true");
            this.setSystemProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
            this.setSystemProperty("com.sun.jndi.ldap.connect.pool.authentication", "none simple DIGEST-MD5");
            this.setSystemProperty("com.sun.jndi.ldap.connect.pool.timeout", Integer.toString(serverConfig.getPoolingTimeout()));
        }
        if (!serverConfig.isVerifyServerCert() && serverConfig.useSsl) {
            props.put("java.naming.ldap.factory.socket", "org.nuxeo.ecm.directory.ldap.LDAPDirectory$TrustingSSLSocketFactory");
        }
        return props;
    }

    protected void setSystemProperty(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }

    public Properties getContextProperties() {
        return this.contextProperties;
    }

    protected SearchControls computeSearchControls() throws DirectoryException {
        LDAPDirectoryDescriptor ldapDirectoryDesc = this.getDescriptor();
        SearchControls scts = new SearchControls();
        scts.setSearchScope(ldapDirectoryDesc.getSearchScope());
        HashSet<String> attrs = new HashSet<String>();
        for (String fieldName : this.getSchemaFieldMap().keySet()) {
            if (this.references.containsKey(fieldName)) continue;
            attrs.add(this.fieldMapper.getBackendField(fieldName));
        }
        attrs.add("objectClass");
        for (Reference reference : this.getReferences()) {
            if (!(reference instanceof LDAPReference)) continue;
            LDAPReference ldapReference = (LDAPReference)reference;
            attrs.add(ldapReference.getStaticAttributeId(this.fieldMapper));
            attrs.add(ldapReference.getDynamicAttributeId());
            for (LDAPDynamicReferenceDescriptor dynAtt : ldapReference.getDynamicAttributes()) {
                attrs.add(dynAtt.baseDN);
                attrs.add(dynAtt.filter);
            }
        }
        if (this.getPasswordField() != null) {
            attrs.remove(this.getPasswordField());
        }
        scts.setReturningAttributes(attrs.toArray(new String[attrs.size()]));
        scts.setCountLimit(ldapDirectoryDesc.getQuerySizeLimit());
        scts.setTimeLimit(ldapDirectoryDesc.getQueryTimeLimit());
        return scts;
    }

    public SearchControls getSearchControls() {
        return this.getSearchControls(false);
    }

    public SearchControls getSearchControls(boolean fetchAllAttributes) {
        if (fetchAllAttributes) {
            LDAPDirectoryDescriptor ldapDirectoryDesc = this.getDescriptor();
            SearchControls scts = new SearchControls();
            scts.setSearchScope(ldapDirectoryDesc.getSearchScope());
            return scts;
        }
        return this.searchControls;
    }

    protected DirContext createContext() throws DirectoryException {
        try {
            String serverName = this.getDescriptor().getServerName();
            if (StringUtils.isEmpty((String)serverName)) {
                throw new DirectoryException("server configuration is missing for directory " + this.getName());
            }
            LDAPServerDescriptor serverConfig = this.getServer();
            if (serverConfig.isDynamicServerList()) {
                String ldapUrls = serverConfig.getLdapUrls();
                this.contextProperties.put("java.naming.provider.url", ldapUrls);
            }
            return new InitialDirContext(this.contextProperties);
        }
        catch (NamingException e) {
            throw new DirectoryException("Cannot connect to LDAP directory '" + this.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public LDAPServerDescriptor getServer() {
        return this.factory.getServer(this.getDescriptor().getServerName());
    }

    public Session getSession() throws DirectoryException {
        this.initLDAPConfigIfNeeded();
        LDAPSession session = new LDAPSession(this);
        this.addSession((Session)session);
        return session;
    }

    public String getBaseFilter() {
        String idField = this.getIdField();
        String idAttribute = this.getFieldMapper().getBackendField(idField);
        String idFilter = String.format("(%s=*)", idAttribute);
        if (this.baseFilter != null && !"".equals(this.baseFilter)) {
            return this.baseFilter;
        }
        return idFilter;
    }

    protected ContextProvider getTestServer() {
        return this.testServer;
    }

    public void setTestServer(ContextProvider testServer) {
        this.testServer = testServer;
    }

    public static class TrustingSSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory factory;

        public TrustingSSLSocketFactory() {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new TrustingX509TrustManager()}, new SecureRandom());
                this.factory = sslContext.getSocketFactory();
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("Unable to initialize the SSL context:  ", nsae);
            }
            catch (KeyManagementException kme) {
                throw new RuntimeException("Unable to register a trust manager:  ", kme);
            }
        }

        public static SocketFactory getDefault() {
            return TrustingSSLSocketFactoryHolder.INSTANCE;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.factory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.factory.createSocket(s, host, port, autoClose);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.factory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.factory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.factory.createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.factory.createSocket(address, port, localAddress, localPort);
        }

        private class TrustingX509TrustManager
        implements X509TrustManager {
            private TrustingX509TrustManager() {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }

        private static class TrustingSSLSocketFactoryHolder {
            public static final TrustingSSLSocketFactory INSTANCE = new TrustingSSLSocketFactory();

            private TrustingSSLSocketFactoryHolder() {
            }
        }
    }
}

