/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.nuxeo.ecm.directory.ldap.LdapExceptionProcessor;

public class DefaultLdapExceptionProcessor
implements LdapExceptionProcessor {
    protected Pattern err53 = Pattern.compile(".*\\[LDAP: error code 53 - (.*)\\].*");

    @Override
    public RecoverableClientException extractRecoverableException(Exception e) {
        String errMsg = e.getMessage();
        if (errMsg == null) {
            return null;
        }
        Matcher matcher53 = this.err53.matcher(errMsg);
        if (matcher53.matches()) {
            String userMessage = matcher53.group(1);
            return new RecoverableClientException(userMessage, userMessage, null, (Throwable)e);
        }
        return null;
    }
}

