/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.krb5;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;

public class Krb5Authenticator
implements NuxeoAuthenticationPlugin {
    private static final Log logger = LogFactory.getLog(Krb5Authenticator.class);
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String AUTHORIZATION = "Authorization";
    private static final String NEGOTIATE = "Negotiate";
    private static final String SKIP_KERBEROS = "X-Skip-Kerberos";
    private static final GSSManager MANAGER = GSSManager.getInstance();
    private LoginContext loginContext = null;
    private GSSCredential serverCredential = null;
    private boolean disabled = false;
    private PrivilegedExceptionAction<GSSCredential> getServerCredential = new PrivilegedExceptionAction<GSSCredential>(){

        @Override
        public GSSCredential run() throws GSSException {
            return MANAGER.createCredential(null, 0, new Oid[]{new Oid("1.3.6.1.5.5.2"), new Oid("1.2.840.113554.1.2.2")}, 2);
        }
    };

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public Boolean handleLoginPrompt(HttpServletRequest req, HttpServletResponse res, String baseURL) {
        logger.debug((Object)"Sending login prompt...");
        res.setHeader(WWW_AUTHENTICATE, NEGOTIATE);
        res.setHeader("Refresh", "1;url=login.jsp");
        res.setStatus(401);
        res.setContentLength(0);
        try {
            res.flushBuffer();
        }
        catch (IOException e) {
            logger.warn((Object)"Cannot flush response", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest req, HttpServletResponse res) {
        String authorization = req.getHeader(AUTHORIZATION);
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith(NEGOTIATE)) {
            logger.warn((Object)("Received invalid Authorization header (expected: Negotiate then SPNEGO blob): " + authorization));
            return null;
        }
        byte[] token = new Base64(-1).decode(authorization.substring(NEGOTIATE.length() + 1));
        byte[] respToken = null;
        GSSContext context = null;
        try {
            Krb5Authenticator krb5Authenticator = this;
            synchronized (krb5Authenticator) {
                context = MANAGER.createContext(this.serverCredential);
                respToken = context.acceptSecContext(token, 0, token.length);
            }
            if (context.isEstablished()) {
                String principal = ((Object)context.getSrcName()).toString();
                String username = principal.split("@")[0];
                UserIdentificationInfo info = new UserIdentificationInfo(username, "Trust");
                info.setLoginPluginName("Trusting_LM");
                return info;
            }
            res.setHeader(WWW_AUTHENTICATE, "Negotiate " + new Base64(-1).encode(respToken));
            return null;
        }
        catch (GSSException ge) {
            logger.error((Object)"Cannot accept provided security token", (Throwable)ge);
            return null;
        }
    }

    public void initPlugin(Map<String, String> parameters) {
        try {
            this.loginContext = new LoginContext("Nuxeo");
            this.loginContext.login();
            this.serverCredential = Subject.doAs(this.loginContext.getSubject(), this.getServerCredential);
            logger.debug((Object)"Successfully initialized Kerberos auth module");
        }
        catch (LoginException le) {
            logger.error((Object)"Cannot create LoginContext, disabling Kerberos module", (Throwable)le);
            this.disabled = true;
        }
        catch (PrivilegedActionException pae) {
            logger.error((Object)"Cannot get server credentials, disabling Kerberos module", (Throwable)pae);
            this.disabled = true;
        }
    }

    public Boolean needLoginPrompt(HttpServletRequest req) {
        return !this.disabled && req.getHeader(SKIP_KERBEROS) == null;
    }
}

