/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.platform.importer.properties.MetadataCollector;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class FileWithMetadataSourceNode
extends FileSourceNode {
    protected static MetadataCollector collector = new MetadataCollector();
    public static final String METADATA_FILENAME = "metadata.properties";
    private static final Log log = LogFactory.getLog(FileWithMetadataSourceNode.class);

    public FileWithMetadataSourceNode(File file) {
        super(file);
    }

    public FileWithMetadataSourceNode(String path) {
        super(path);
    }

    @Override
    public BlobHolder getBlobHolder() throws IOException {
        SimpleBlobHolderWithProperties bh = new SimpleBlobHolderWithProperties(Blobs.createBlob((File)this.file), collector.getProperties(this.file.getPath()));
        return bh;
    }

    @Override
    public List<SourceNode> getChildren() {
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        for (File child : this.file.listFiles()) {
            if (!METADATA_FILENAME.equals(child.getName())) continue;
            try {
                collector.addPropertyFile(child);
            }
            catch (IOException e) {
                log.error((Object)"Error during properties parsing", (Throwable)e);
            }
            break;
        }
        for (File child : this.file.listFiles()) {
            if (METADATA_FILENAME.equals(child.getName())) continue;
            children.add(new FileWithMetadataSourceNode(child));
        }
        return children;
    }
}

