/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class MetadataCollector {
    protected boolean staticInherit = true;
    protected boolean useIntrospection = false;
    public static final String DATE_FORMAT = "MM/dd/yyyy";
    public static final String LIST_SEPARATOR = "|";
    public static final String REGEXP_LIST_SEPARATOR = "\\|";
    public static final String ARRAY_SEPARATOR = "||";
    public static final String REGEXP_ARRAY_SEPARATOR = "\\|\\|";
    protected Map<String, Map<String, Serializable>> collectedMetadata = new HashMap<String, Map<String, Serializable>>();
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected static Pattern numPattern = Pattern.compile("([0-9\\,\\.\\+\\-]+)");

    public void addPropertiesFromStrings(String contextPath, Map<String, String> properties) {
        HashMap<String, Serializable> collectedProperties = new HashMap<String, Serializable>();
        for (Map.Entry<String, String> es : properties.entrySet()) {
            String name = es.getKey();
            Serializable value = this.parseFromString(name, es.getValue());
            collectedProperties.put(name, value);
        }
        this.addProperties(contextPath, collectedProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(String contextPath, Map<String, Serializable> collectedProperties) {
        try {
            this.lock.writeLock().lock();
            contextPath = FilenameUtils.normalizeNoEndSeparator((String)contextPath);
            if (this.staticInherit) {
                File file = new File(contextPath);
                while (!StringUtils.isEmpty((CharSequence)file.getParent())) {
                    Map<String, Serializable> parentProperties = this.collectedMetadata.get((file = file.getParentFile()).toString());
                    if (parentProperties == null) continue;
                    for (String name : parentProperties.keySet()) {
                        if (collectedProperties.containsKey(name)) continue;
                        collectedProperties.put(name, parentProperties.get(name));
                    }
                }
            }
            this.collectedMetadata.put(contextPath, collectedProperties);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected Serializable parseFromString(String name, String value) {
        Object prop = value;
        if (this.useIntrospection) {
            throw new UnsupportedOperationException("Introspection mode not available");
        }
        if (value.contains(ARRAY_SEPARATOR)) {
            prop = value.split(REGEXP_ARRAY_SEPARATOR);
        } else if (value.contains(LIST_SEPARATOR)) {
            String[] parts;
            ArrayList<Serializable> lstprop = new ArrayList<Serializable>();
            for (String part : parts = value.split(REGEXP_LIST_SEPARATOR)) {
                lstprop.add(this.parseFromString(name, part));
            }
            prop = lstprop;
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getProperty(String contextPath, String name) {
        Map<String, Serializable> props = this.getProperties(contextPath);
        if (props != null) {
            try {
                this.lock.readLock().lock();
                Serializable serializable = props.get(name);
                return serializable;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Serializable> getProperties(String contextPath) {
        contextPath = FilenameUtils.normalizeNoEndSeparator((String)contextPath);
        try {
            this.lock.readLock().lock();
            Map<String, Serializable> props = this.collectedMetadata.get(contextPath);
            if (props == null) {
                File file = new File(contextPath);
                while (props == null && !StringUtils.isEmpty((CharSequence)file.getParent())) {
                    file = file.getParentFile();
                    props = this.collectedMetadata.get(file.getPath());
                }
            }
            if (props != null) {
                props = Collections.unmodifiableMap(props);
            }
            Map<String, Serializable> map = props;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addPropertyFile(File propertyFile) throws IOException {
        Properties mdProperties = new Properties();
        try (FileInputStream in = new FileInputStream(propertyFile);){
            mdProperties.load(in);
        }
        HashMap<String, String> stringMap = new HashMap<String, String>();
        Enumeration<?> names = mdProperties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            stringMap.put(name, mdProperties.getProperty(name));
        }
        String contextPath = new File(propertyFile.getPath()).getParent();
        this.addPropertiesFromStrings(contextPath, stringMap);
    }
}

