/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.blob.s3;

import com.amazonaws.auth.PEM;
import com.amazonaws.auth.RSA;
import com.amazonaws.services.cloudfront.util.SignerUtils;
import com.amazonaws.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import org.nuxeo.ecm.blob.CloudBlobStoreConfiguration;
import org.nuxeo.runtime.api.Framework;

public class CloudFrontConfiguration
extends CloudBlobStoreConfiguration {
    public static final String CLOUDFRONT_ENABLED_PROPERTY = "cloudfront.enabled";
    public static final String CLOUDFRONT_PRIVATE_KEY_PROPERTY = "cloudfront.privKey";
    public static final String CLOUDFRONT_PRIVATE_KEY_ID_PROPERTY = "cloudfront.privKeyId";
    public static final String CLOUDFRONT_DISTRIBUTION_DOMAIN_PROPERTY = "cloudfront.distribDomain";
    public static final String CLOUDFRONT_PROTOCOL_PROPERTY = "cloudfront.protocol";
    public static final String CLOUDFRONT_ENABLE_ENCODING_FIX = "nuxeo.s3storage.cloudfront.fix.encoding";
    public final boolean enabled = this.getBooleanProperty("cloudfront.enabled");
    public final String distributionDomain;
    public final SignerUtils.Protocol protocol;
    public final PrivateKey privateKey;
    public final String keyPairId;
    public final boolean fixEncoding;

    public CloudFrontConfiguration(String systemPropertyPrefix, Map<String, String> properties) throws IOException {
        super(systemPropertyPrefix, properties);
        if (this.enabled) {
            this.protocol = SignerUtils.Protocol.valueOf((String)this.getProperty(CLOUDFRONT_PROTOCOL_PROPERTY, "https"));
            this.distributionDomain = this.getProperty(CLOUDFRONT_DISTRIBUTION_DOMAIN_PROPERTY);
            this.privateKey = this.getPrivateKey(this.getProperty(CLOUDFRONT_PRIVATE_KEY_PROPERTY));
            this.keyPairId = this.getProperty(CLOUDFRONT_PRIVATE_KEY_ID_PROPERTY);
            this.fixEncoding = Framework.isBooleanPropertyTrue((String)CLOUDFRONT_ENABLE_ENCODING_FIX);
        } else {
            this.protocol = null;
            this.distributionDomain = null;
            this.privateKey = null;
            this.keyPairId = null;
            this.fixEncoding = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PrivateKey getPrivateKey(String path) throws IOException {
        if (path == null) {
            return null;
        }
        try (InputStream in = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            if (path.toLowerCase().endsWith(".pem")) {
                PrivateKey privateKey = PEM.readPrivateKey((InputStream)in);
                return privateKey;
            }
            if (!path.toLowerCase().endsWith(".der")) throw new IllegalArgumentException("Unsupported file type");
            PrivateKey privateKey = RSA.privateKeyFromPKCS8((byte[])IOUtils.toByteArray((InputStream)in));
            return privateKey;
        }
        catch (IllegalArgumentException | InvalidKeySpecException e) {
            throw new IOException("Invalid CloudFront private key: " + path, e);
        }
    }
}

