/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsIndexBuilder
implements AnnotationProcessorFactory {
    private static final Set<String> supportedAnnotations = new HashSet<String>(Arrays.asList("org.nuxeo.ecm.webengine.model.WebObject", "org.nuxeo.ecm.webengine.model.WebAdapter"));
    private static final String EOL = System.getProperty("line.separator");
    private static final Collection<String> supportedOptions = Collections.emptySet();
    protected AnnotationProcessorEnvironment env;

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        Object result = null;
        result = atds.isEmpty() ? AnnotationProcessors.NO_OP : new Processor(env);
        return result;
    }

    private static class Processor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;
        protected PrintWriter writer;
        protected StringBuilder buf;

        Processor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public static final String encode(TypeMirror type, Object value) {
            return value.toString();
        }

        public void process() {
            try {
                this.buf = new StringBuilder();
                Messager log = this.env.getMessager();
                DeclarationVisitor scanner = DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new Visitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP);
                for (TypeDeclaration typeDecl : this.env.getSpecifiedTypeDeclarations()) {
                    typeDecl.accept(scanner);
                }
                if (this.buf.length() > 0) {
                    this.writer = this.env.getFiler().createTextFile(Filer.Location.CLASS_TREE, "", new File("META-INF/web-types"), "UTF-8");
                    this.writer.print(this.buf.toString());
                    this.writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        class Visitor
        extends SimpleDeclarationVisitor {
            Visitor() {
            }

            public void visitClassDeclaration(ClassDeclaration d) {
                String className = d.getQualifiedName();
                for (AnnotationMirror anno : d.getAnnotationMirrors()) {
                    AnnotationTypeDeclaration adecl = anno.getAnnotationType().getDeclaration();
                    if (!supportedAnnotations.contains(adecl.getQualifiedName())) continue;
                    Processor.this.buf.append(className).append('|').append(adecl.getQualifiedName());
                    ArrayList<String> indexes = null;
                    for (AnnotationMirror annotationMirror : adecl.getAnnotationMirrors()) {
                        if (!annotationMirror.getAnnotationType().getDeclaration().getQualifiedName().equals("org.nuxeo.runtime.annotations.loader.Indexable")) continue;
                        List values = (List)((AnnotationValue)annotationMirror.getElementValues().values().iterator().next()).getValue();
                        indexes = new ArrayList<String>(values.size());
                        for (AnnotationValue v : values) {
                            indexes.add((String)v.getValue());
                        }
                    }
                    if (indexes != null) {
                        Processor.this.buf.append('|');
                        for (Map.Entry entry : anno.getElementValues().entrySet()) {
                            AnnotationTypeElementDeclaration akey = (AnnotationTypeElementDeclaration)entry.getKey();
                            String key = akey.getSimpleName();
                            if (!indexes.contains(key)) continue;
                            AnnotationValue aval = (AnnotationValue)entry.getValue();
                            if (aval == null) {
                                aval = akey.getDefaultValue();
                            }
                            TypeMirror type = akey.getReturnType();
                            Object value = aval.getValue();
                            Processor.this.buf.append(key).append('|').append(Processor.encode(type, value)).append('|');
                        }
                        Processor.this.buf.setLength(Processor.this.buf.length() - 1);
                    }
                    Processor.this.buf.append(EOL);
                }
            }
        }
    }
}

