/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.task;

import com.iss.nuxeo.bulkimport.task.TaskInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.importer.executor.jaxrs.HttpFileImporterExecutor;
import org.nuxeo.runtime.api.Framework;

public class TaskPool {
    private Map<TaskInfo, HttpFileImporterExecutor> tasks = new HashMap<TaskInfo, HttpFileImporterExecutor>();
    private int maxTasks = 1;
    private static TaskPool instance;

    private TaskPool() {
        String max = Framework.getProperty((String)"TASKS_MAX_SIZE_PROP");
        if (StringUtils.isNumeric((CharSequence)max)) {
            this.maxTasks = Integer.parseInt(max);
        }
    }

    public static synchronized TaskPool get() {
        if (instance == null) {
            instance = new TaskPool();
        }
        return instance;
    }

    public synchronized TaskInfo createTask(HttpFileImporterExecutor executor) {
        if (this.tasks.size() >= this.maxTasks) {
            this.clear();
        }
        if (this.tasks.size() >= this.maxTasks) {
            return null;
        }
        TaskInfo task = TaskInfo.asTaskInfo(this.generateTaskId());
        this.tasks.put(task, executor);
        return task;
    }

    public HttpFileImporterExecutor getTaskExecutor(String taskId) {
        return this.tasks.get(TaskInfo.asTaskInfo(taskId));
    }

    public List<TaskInfo> listTasks() {
        ArrayList<TaskInfo> tasks = new ArrayList<TaskInfo>();
        tasks.addAll(this.tasks.keySet());
        return tasks;
    }

    public int getMaxTaskSize() {
        return this.maxTasks;
    }

    private void clear() {
        this.tasks.values().removeIf(t -> !t.isRunning());
    }

    public String generateTaskId() {
        return UUID.randomUUID().toString();
    }
}

