/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.iss.nuxeo.bulkimport.common.StringTool;
import com.iss.nuxeo.bulkimport.s3.IssS3Utils;
import com.iss.nuxeo.bulkimport.s3.S3OperationTrace;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;

public class S3Operation {
    private static final Log log = LogFactory.getLog(S3BinaryManager.class);
    public static final String TRACE_LEVEL_PROPERTY = "trace.level";
    public static final String SINGLE_PART_MAXSIZE_PROPERTY = "singlepart.maxsize";
    protected long singlePartMaxSize = 0x140000000L;
    protected AmazonS3 amazonS3;
    protected String bucketName;
    protected String bucketPrefix = "";
    protected String dummyETag = "00000000000000000000000000000000-1";
    protected S3OperationTrace.TraceLevel traceLevel;
    protected String blobProviderId;

    private S3Operation() {
    }

    public ObjectMetadata copy(String sourceBucket, String sourceKey, String targetBucket, String targetKey, String targetSSEAlgorithm) {
        return this.copy(sourceBucket, sourceKey, targetBucket, targetKey, targetSSEAlgorithm, true);
    }

    private ObjectMetadata copy(String sourceBucket, String sourceKey, String targetBucket, String targetKey, String targetSSEAlgorithm, boolean trace) {
        long length;
        ObjectMetadata sourceMetadata = this.amazonS3.getObjectMetadata(sourceBucket, sourceKey);
        S3OperationTrace s3trace = null;
        if (trace) {
            s3trace = S3OperationTrace.get(log, null, this.traceLevel);
            s3trace.stepBegins("copy", sourceBucket, sourceKey, sourceMetadata, targetBucket, targetKey);
        }
        ObjectMetadata newMetadata = (length = sourceMetadata.getContentLength()) > this.singlePartMaxSize ? IssS3Utils.copyFile(this.amazonS3, sourceMetadata, sourceBucket, sourceKey, targetBucket, targetKey, targetSSEAlgorithm, false) : IssS3Utils.copyFileNonMultipart(this.amazonS3, sourceMetadata, sourceBucket, sourceKey, targetBucket, targetKey, targetSSEAlgorithm, false);
        if (trace) {
            s3trace.stepEnds("copy", sourceBucket, sourceKey, targetBucket, targetKey, newMetadata);
        }
        return newMetadata;
    }

    public ObjectMetadata move(String sourceBucket, String sourceKey, String targetBucket, String targetKey, String targetSSEAlgorithm) {
        return this.move(sourceBucket, sourceKey, targetBucket, targetKey, targetSSEAlgorithm, true);
    }

    private ObjectMetadata move(String sourceBucket, String sourceKey, String targetBucket, String targetKey, String targetSSEAlgorithm, boolean trace) {
        long length;
        ObjectMetadata sourceMetadata = this.amazonS3.getObjectMetadata(sourceBucket, sourceKey);
        S3OperationTrace s3trace = null;
        if (trace) {
            s3trace = S3OperationTrace.get(log, null, this.traceLevel);
            s3trace.stepBegins("move", sourceBucket, sourceKey, sourceMetadata, targetBucket, targetKey);
        }
        ObjectMetadata newMetadata = (length = sourceMetadata.getContentLength()) > this.singlePartMaxSize ? IssS3Utils.copyFile(this.amazonS3, sourceMetadata, sourceBucket, sourceKey, targetBucket, targetKey, targetSSEAlgorithm, true) : IssS3Utils.copyFileNonMultipart(this.amazonS3, sourceMetadata, sourceBucket, sourceKey, targetBucket, targetKey, targetSSEAlgorithm, true);
        if (trace) {
            s3trace.stepEnds("move", sourceBucket, sourceKey, targetBucket, targetKey, newMetadata);
        }
        return newMetadata;
    }

    public ObjectMetadata renameToDigest(String key, String sseAlgorithm) {
        S3OperationTrace trace = S3OperationTrace.get(log, "rename to digest", this.traceLevel);
        trace.operationBegins(this.bucketName, key);
        String objectName = this.getObjectName(key);
        ObjectMetadata metadata = null;
        try {
            metadata = this.amazonS3.getObjectMetadata(this.bucketName, key);
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                log.error((Object)String.format("not find s3 object with key {%s} on bucket {%s}, blobprovider [%s]", key, this.bucketName, this.blobProviderId), (Throwable)e);
            }
            throw e;
        }
        String etag = metadata.getETag();
        if (!this.isMultipartDigest(etag) && etag.equals(objectName)) {
            trace.operationEnds(this.bucketName, key, this.bucketName, key, metadata);
            return metadata;
        }
        String newKey = this.dummyETag.equals(etag) ? this.getUUID() : etag;
        String finalKey = StringUtils.isBlank((CharSequence)this.bucketPrefix) ? newKey : this.bucketPrefix + newKey;
        String step = this.isMultipartDigest(etag) ? "compute md5" : "rename to digest";
        trace.stepBegins(step, this.bucketName, key, metadata, this.bucketName, finalKey);
        metadata = this.copy(this.bucketName, key, this.bucketName, finalKey, sseAlgorithm, false);
        trace.stepEnds(step, this.bucketName, key, this.bucketName, finalKey, metadata);
        String finalETag = metadata.getETag();
        if (!etag.equals(finalETag)) {
            step = "rename";
            String previousKey = finalKey;
            finalKey = StringUtils.isBlank((CharSequence)this.bucketPrefix) ? finalETag : this.bucketPrefix + finalETag;
            trace.stepBegins(step, this.bucketName, previousKey, metadata, this.bucketName, finalKey);
            metadata = this.move(this.bucketName, previousKey, this.bucketName, finalKey, sseAlgorithm, false);
            trace.stepEnds(step, this.bucketName, previousKey, this.bucketName, finalKey, metadata);
        }
        trace.operationEnds(this.bucketName, key, this.bucketName, finalKey, metadata);
        return metadata;
    }

    public List<String> listFolders(String bucket, String prefix) {
        ListObjectsRequest req = new ListObjectsRequest().withBucketName(bucket).withDelimiter("/").withPrefix(prefix);
        ObjectListing list = this.amazonS3.listObjects(req);
        List prefixes = list.getCommonPrefixes();
        return prefixes;
    }

    public List<String> listFolders(String prefix) {
        return this.listFolders(this.bucketName, prefix);
    }

    public List<String> listFiles(String bucket, String prefix) {
        ListObjectsRequest req = new ListObjectsRequest().withBucketName(bucket).withDelimiter("/").withPrefix(prefix);
        ObjectListing list = this.amazonS3.listObjects(req);
        List<String> result = list.getObjectSummaries().stream().map(o -> o.getKey()).collect(Collectors.toList());
        while (list.isTruncated()) {
            list = this.amazonS3.listNextBatchOfObjects(list);
            result.addAll(list.getObjectSummaries().stream().map(o -> o.getKey()).collect(Collectors.toList()));
        }
        result.remove(prefix);
        return result;
    }

    public List<String> listFiles(String prefix) {
        return this.listFiles(this.bucketName, prefix);
    }

    public ObjectMetadata getObjectMetadata(String key, boolean supress404) {
        try {
            return this.amazonS3.getObjectMetadata(this.bucketName, key);
        }
        catch (AmazonServiceException e) {
            if (supress404 && this.isMissingKey(e)) {
                return null;
            }
            log.error((Object)String.format("failed to find s3 object with key {%s} on bucket {%s}, blobprovider [%s]", key, this.bucketName, this.blobProviderId), (Throwable)e);
            throw e;
        }
    }

    private boolean isMissingKey(AmazonServiceException e) {
        return e.getStatusCode() == 404 || "NoSuchKey".equals(e.getErrorCode()) || "Not Found".equals(e.getMessage());
    }

    public AmazonS3 getAmazonS3() {
        return this.amazonS3;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getBucketPrefix() {
        return this.bucketPrefix;
    }

    public String getUUID() {
        return "BI-" + UUID.randomUUID();
    }

    public boolean isMultipartDigest(String etag) {
        return etag.indexOf(45) != -1;
    }

    public boolean isDummyETag(String etag) {
        return this.dummyETag.equals(etag);
    }

    private String getObjectName(String key) {
        if (key == null) {
            return null;
        }
        int pos = key.lastIndexOf("/");
        return key.substring(pos + 1, key.length());
    }

    public static class S3OperationBuilder {
        private S3Operation operation;

        public static S3OperationBuilder withAmazonS3(AmazonS3 amazonS3) {
            S3OperationBuilder builder = new S3OperationBuilder();
            builder.operation = new S3Operation();
            builder.operation.amazonS3 = amazonS3;
            return builder;
        }

        public static S3OperationBuilder withS3BlobProvider(S3BinaryManager blobProvider) {
            S3OperationBuilder builder = S3OperationBuilder.withAmazonS3(blobProvider.getAmazonS3()).withProperties(blobProvider.getProperties());
            return builder;
        }

        public S3OperationBuilder withProperties(Map<String, String> properties) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("initialize with properties: " + properties));
            }
            if (properties != null) {
                this.operation.bucketName = properties.get("bucket");
                this.operation.bucketPrefix = StringUtils.defaultString((String)properties.get("bucket_prefix"), (String)this.operation.bucketPrefix);
                this.operation.singlePartMaxSize = StringTool.parseByteSize(properties.get(S3Operation.SINGLE_PART_MAXSIZE_PROPERTY), 0x140000000L);
                this.operation.traceLevel = S3OperationTrace.TraceLevel.fromString(properties.get(S3Operation.TRACE_LEVEL_PROPERTY));
            }
            return this;
        }

        public S3OperationBuilder withBucketName(String name) {
            this.operation.bucketName = name;
            return this;
        }

        public S3OperationBuilder withBucketPrefix(String prefix) {
            this.operation.bucketPrefix = prefix;
            return this;
        }

        public S3OperationBuilder withTraceLevel(String level) {
            this.operation.traceLevel = S3OperationTrace.TraceLevel.fromString(level);
            return this;
        }

        public S3OperationBuilder withSinglePartMaxSize(String maxSize) {
            this.operation.singlePartMaxSize = StringTool.parseByteSize(maxSize, 0x140000000L);
            return this;
        }

        public S3OperationBuilder withBlobProviderId(String id) {
            this.operation.blobProviderId = id;
            return this;
        }

        public S3Operation build() {
            return this.operation;
        }
    }
}

