/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.s3;

import com.iss.nuxeo.bulkimport.s3.S3BlobProviders;
import com.iss.nuxeo.bulkimport.s3.S3BlobTransfer;
import com.iss.nuxeo.bulkimport.s3.S3Operation;
import com.iss.nuxeo.bulkimport.s3.S3SourceNode;
import com.iss.nuxeo.bulkimport.source.AbstractFileSourceProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class S3FileSourceProvider
extends AbstractFileSourceProvider {
    private static final Log log = LogFactory.getLog(S3FileSourceProvider.class);
    protected S3Operation s3;
    protected S3BlobTransfer s3BlobTransfer;

    @Override
    public void initialize(String id, Map<String, String> properties) {
        super.initialize(id, properties);
        String sourceBlobProvider = properties.get("sourceBlobProvider");
        if (StringUtils.isBlank((CharSequence)sourceBlobProvider)) {
            throw new NuxeoException(String.format("[sourceBlobProvider] is missing in S3FileSourceProvider [%s]'s properties.", id));
        }
        S3BinaryManager s3bm = S3BlobProviders.getS3BlobProvider(sourceBlobProvider);
        if (s3bm == null) {
            throw new NuxeoException(String.format("Failed to initialize S3FileSourceProvider [%s] because can't find blobprovider with id [%2s].", id, sourceBlobProvider));
        }
        this.s3 = S3Operation.S3OperationBuilder.withS3BlobProvider(s3bm).withBlobProviderId(sourceBlobProvider).build();
        String transientBlobProvider = properties.get("transientBlobProvider");
        if (StringUtils.isBlank((CharSequence)transientBlobProvider)) {
            log.warn((Object)String.format("[transientBlobProvider] is missing in S3FileSourceProvider [%s]'s properties, will use [%s] as the transient blob provider.", id, sourceBlobProvider));
        }
        this.s3BlobTransfer = S3BlobTransfer.withSourceBlobProvider(sourceBlobProvider).withTransientBlobProvider(transientBlobProvider);
    }

    @Override
    public List<String> getSourceChildren(String location, boolean onlyName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("get sublocations for [%s]", location));
        }
        String prefix = this.getAbsolutePath(location, true);
        List<String> results = this.s3.listFolders(this.s3.getBucketName(), prefix);
        if (onlyName) {
            results = results.stream().map(c -> onlyName ? StringUtils.removeStart((String)c, (String)prefix) : StringUtils.removeStart((String)c, (String)this.s3.getBucketPrefix())).map(c -> StringUtils.removeEnd((String)c, (String)"/")).collect(Collectors.toList());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sublocations for [%s]: %s", location, results));
        }
        return results;
    }

    public String getAbsolutePath(String path, boolean isFolderish) {
        String prefix = this.s3.getBucketPrefix();
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            path = StringUtils.removeStart((String)path, (String)"/");
            path = prefix + (String)path;
        }
        path = StringUtils.removeStart((String)path, (String)"/");
        if (isFolderish && !((String)path).isEmpty()) {
            path = StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return path;
    }

    @Override
    public List<SourceNode> getChildrenSourceNodes(String location) throws IOException {
        if (!location.endsWith("/")) {
            return null;
        }
        List<SourceNode> results = this.s3.listFolders(this.getAbsolutePath(location, true)).stream().map(c -> this.toSourceNodePath((String)c)).map(S3SourceNode::fromString).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s folders under %s", results.size(), location));
        }
        List files = this.s3.listFiles(this.getAbsolutePath(location, true)).stream().map(c -> this.toSourceNodePath((String)c)).map(S3SourceNode::fromString).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s files under %s", files.size(), location));
        }
        results.addAll(files);
        return results;
    }

    @Override
    public BlobHolder getBlobHolder(String location) throws IOException {
        if (location.endsWith("/")) {
            return new SimpleBlobHolder((Blob)null);
        }
        String name = this.getLastPathName(location);
        BlobHolder bh = this.s3BlobTransfer.transfer(location, name);
        return bh;
    }

    private String toSourceNodePath(String s3key) {
        return this.id + ":" + StringUtils.removeStart((String)s3key, (String)this.s3.getBucketPrefix());
    }
}

