/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.jaxrs;

import com.iss.nuxeo.bulkimport.ImportContext;
import com.iss.nuxeo.bulkimport.common.StringTool;
import com.iss.nuxeo.bulkimport.source.FileSourceManager;
import com.iss.nuxeo.bulkimport.source.FileSourceProvider;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="BulkImportSource")
@Produces(value={"application/json; charset=UTF-8"})
public class BulkImportSource
extends DefaultObject {
    private static final Log log = LogFactory.getLog(BulkImportSource.class);

    @GET
    @Path(value="locations")
    public Response getSourceLocations() {
        try {
            FileSourceProvider provider = this.getFileSetProvider();
            String root = provider.getSourceRoot();
            String result = StringTool.toJson(Collections.singletonMap("root", root));
            return Response.ok((Object)result, (String)"application/json").build();
        }
        catch (Exception e) {
            log.error((Object)"failed to retrieve import root location", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="sublocations")
    public Response getSourceSublocations(@QueryParam(value="baseDir") String baseDir) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("baseDir: " + baseDir));
        }
        try {
            FileSourceProvider provider = this.getFileSetProvider();
            if (!provider.isValidSublocations(baseDir, true)) {
                return Response.status((int)403).entity((Object)(baseDir + " is not a valid folder for bulk import.")).build();
            }
            List<String> list = provider.getSourceChildren(baseDir, true);
            return Response.ok((Object)StringTool.toJson(list)).build();
        }
        catch (Exception e) {
            log.error((Object)"failed to retrieve import sulocations", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    protected FileSourceProvider getFileSetProvider() {
        ImportContext icxt = new ImportContext();
        icxt.setPrincipal(this.ctx.getPrincipal());
        FileSourceManager providers = (FileSourceManager)Framework.getService(FileSourceManager.class);
        return providers.getFileSourceProvider(icxt);
    }
}

