/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.source;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.platform.importer.properties.IndividualMetadataCollector;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class FileWithIndividualMetadasSourceNode
extends FileSourceNode {
    private static final Log log = LogFactory.getLog(FileWithIndividualMetadasSourceNode.class);
    public static final String PROPERTY_FILE_SUFFIX = ".properties";
    @Deprecated
    public static final String PROPERTY_FILE_SUFIX = ".properties";
    protected static IndividualMetadataCollector collector = new IndividualMetadataCollector();

    public FileWithIndividualMetadasSourceNode(File file) {
        super(file);
    }

    public FileWithIndividualMetadasSourceNode(String path) {
        super(path);
    }

    protected FileWithIndividualMetadasSourceNode newInstance(File file) {
        return new FileWithIndividualMetadasSourceNode(file);
    }

    @Override
    public BlobHolder getBlobHolder() throws IOException {
        SimpleBlobHolderWithProperties bh = new SimpleBlobHolderWithProperties(Blobs.createBlob((File)this.file), collector.getProperties(this.file));
        return bh;
    }

    public Map<String, Serializable> getMetadataForFolderishNode() {
        return collector.getProperties(this.file);
    }

    @Override
    public List<SourceNode> getChildren() {
        String base;
        String name;
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        File[] listFiles = this.file.listFiles();
        log.trace((Object)("Element " + this.getSourcePath() + " has " + listFiles.length + " children"));
        HashMap<String, String> paths = new HashMap<String, String>();
        for (File child : listFiles) {
            name = child.getName();
            if (child.isDirectory()) {
                paths.put(name, child.getAbsolutePath());
                continue;
            }
            if (!child.isFile() || name.endsWith(".properties")) continue;
            base = FileWithIndividualMetadasSourceNode.getFileNameNoExt(child);
            paths.put(base, child.getAbsolutePath());
        }
        for (File child : listFiles) {
            name = child.getName();
            if (name.endsWith(".properties")) {
                base = name.substring(0, name.length() - ".properties".length());
                String path = (String)paths.get(base);
                if (path == null) continue;
                try {
                    collector.addPropertyFile(child, path);
                }
                catch (IOException e) {
                    log.error((Object)("Error during properties parsing for: " + child), (Throwable)e);
                }
                continue;
            }
            children.add(this.newInstance(child));
        }
        return children;
    }

    @Deprecated
    protected boolean isPropertyFile(File file) {
        return file.getName().endsWith(".properties");
    }

    public static String getFileNameNoExt(File file) {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        if (p == -1) {
            return name;
        }
        return name.substring(0, p);
    }
}

