/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.platform.importer.filter.ImporterFilter;
import org.nuxeo.runtime.api.Framework;

public class EventServiceConfiguratorFilter
implements ImporterFilter {
    private static final Log log = LogFactory.getLog(EventServiceConfiguratorFilter.class);
    protected boolean blockSyncPostCommitProcessing = false;
    protected boolean blockAsyncProcessing = false;
    protected boolean blockMimeTypeDetection = false;
    protected boolean blockNotifications = true;
    protected boolean blockIndexing = false;
    protected boolean bulkMode = false;
    protected static final String NOTIF_LISTENER = "notificationListener";
    protected static final String MIME_LISTENER = "mimetypeIconUpdater";
    protected static final String INDEXING_LISTENER = "elasticSearchInlineListener";

    public EventServiceConfiguratorFilter(Boolean blockSyncPostCommitProcessing, Boolean blockAsyncProcessing, Boolean blockMimeTypeDetection, Boolean blockIndexing, Boolean bulkMode) {
        if (blockAsyncProcessing != null) {
            this.blockAsyncProcessing = blockAsyncProcessing;
        }
        if (blockSyncPostCommitProcessing != null) {
            this.blockSyncPostCommitProcessing = blockSyncPostCommitProcessing;
        }
        if (blockMimeTypeDetection != null) {
            this.blockMimeTypeDetection = blockMimeTypeDetection;
        }
        if (blockIndexing != null) {
            this.blockIndexing = blockIndexing;
        }
        if (bulkMode != null) {
            this.bulkMode = bulkMode;
        }
    }

    @Override
    public void handleBeforeImport() {
        EventServiceAdmin eventAdmin = (EventServiceAdmin)Framework.getService(EventServiceAdmin.class);
        if (eventAdmin == null) {
            log.error((Object)"EventServiceAdmin service was not found ... Possible that the import process will not proceed ok");
            return;
        }
        eventAdmin.setBulkModeEnabled(this.bulkMode);
        eventAdmin.setBlockAsyncHandlers(this.blockAsyncProcessing);
        eventAdmin.setBlockSyncPostCommitHandlers(this.blockSyncPostCommitProcessing);
        if (this.blockMimeTypeDetection) {
            eventAdmin.setListenerEnabledFlag(MIME_LISTENER, false);
        }
        if (this.blockNotifications) {
            eventAdmin.setListenerEnabledFlag(NOTIF_LISTENER, false);
        }
        if (this.blockIndexing) {
            eventAdmin.setListenerEnabledFlag(INDEXING_LISTENER, false);
        }
    }

    @Override
    public void handleAfterImport(Exception e) {
        EventServiceAdmin eventAdmin = (EventServiceAdmin)Framework.getService(EventServiceAdmin.class);
        if (eventAdmin != null) {
            log.info((Object)"Restoring default event listeners and bulk mode");
            eventAdmin.setBulkModeEnabled(false);
            eventAdmin.setBlockAsyncHandlers(false);
            eventAdmin.setBlockSyncPostCommitHandlers(false);
            eventAdmin.setListenerEnabledFlag(NOTIF_LISTENER, true);
            eventAdmin.setListenerEnabledFlag(MIME_LISTENER, true);
            eventAdmin.setListenerEnabledFlag(INDEXING_LISTENER, true);
        }
    }

    public boolean getBlockNotifications() {
        return this.blockNotifications;
    }

    public void setBlockNotifications(boolean blockNotifications) {
        this.blockNotifications = blockNotifications;
    }

    public String toString() {
        return String.format("blockSyncPostCommitProcessing set %b, blockAsyncProcessing set %b, blockMimeTypeDetection set %b, blockNotifications set %b, blockIndexing set %b, bulkMode set %b", this.blockSyncPostCommitProcessing, this.blockAsyncProcessing, this.blockMimeTypeDetection, this.blockNotifications, this.blockIndexing, this.bulkMode);
    }
}

