/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.executor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.base.ImporterRunner;
import org.nuxeo.ecm.platform.importer.executor.AbstractImporterExecutor;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class DefaultImporterExecutor
extends AbstractImporterExecutor {
    private static final Log log = LogFactory.getLog(DefaultImporterExecutor.class);
    protected GenericMultiThreadedImporter importer = null;
    protected String repositoryName;

    public DefaultImporterExecutor() {
    }

    public DefaultImporterExecutor(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    protected Log getJavaLogger() {
        return log;
    }

    public long getCreatedDocsCounter() {
        return GenericMultiThreadedImporter.getCreatedDocsCounter();
    }

    public String run(String inputPath, String targetPath, Boolean skipRootContainerCreation, Integer batchSize, Integer nbTheards, Boolean interactive) {
        FileSourceNode source = new FileSourceNode(inputPath);
        return this.run(source, targetPath, skipRootContainerCreation, batchSize, nbTheards, interactive);
    }

    public String run(SourceNode source, String targetPath, Boolean skipRootContainerCreation, Integer batchSize, Integer nbTheards, Boolean interactive) {
        this.importer = new GenericMultiThreadedImporter(source, targetPath, skipRootContainerCreation, batchSize, nbTheards, this.getLogger());
        this.importer.setFactory(this.getFactory());
        this.importer.setThreadPolicy(this.getThreadPolicy());
        this.importer.setTransactionTimeout(this.getTransactionTimeout());
        return this.doRun(this.importer, interactive);
    }

    @Override
    public String run(ImporterRunner runner, Boolean interactive) {
        return this.doRun(runner, interactive);
    }
}

