/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptedPutObjectRequest;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.blob.AbstractBinaryGarbageCollector;
import org.nuxeo.ecm.blob.AbstractCloudBinaryManager;
import org.nuxeo.ecm.blob.s3.S3ManagedTransfer;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.CachingBinaryManager;
import org.nuxeo.ecm.core.blob.binary.FileStorage;
import org.nuxeo.ecm.core.storage.sql.S3Utils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.aws.AWSConfigurationService;
import org.nuxeo.runtime.aws.NuxeoAWSRegionProvider;

public class S3BinaryManager
extends AbstractCloudBinaryManager
implements S3ManagedTransfer {
    private static final Log log = LogFactory.getLog(S3BinaryManager.class);
    public static final String SYSTEM_PROPERTY_PREFIX = "nuxeo.s3storage";
    public static final String BUCKET_NAME_PROPERTY = "bucket";
    public static final String BUCKET_PREFIX_PROPERTY = "bucket_prefix";
    public static final String BUCKET_REGION_PROPERTY = "region";
    public static final String AWS_ID_PROPERTY = "awsid";
    public static final String AWS_SECRET_PROPERTY = "awssecret";
    public static final String AWS_SESSION_TOKEN_PROPERTY = "awstoken";
    public static final String CONNECTION_MAX_PROPERTY = "connection.max";
    public static final String CONNECTION_RETRY_PROPERTY = "connection.retry";
    public static final String CONNECTION_TIMEOUT_PROPERTY = "connection.timeout";
    public static final String SOCKET_TIMEOUT_PROPERTY = "socket.timeout";
    public static final String KEYSTORE_FILE_PROPERTY = "crypt.keystore.file";
    public static final String KEYSTORE_PASS_PROPERTY = "crypt.keystore.password";
    public static final String SERVERSIDE_ENCRYPTION_PROPERTY = "crypt.serverside";
    public static final String SERVERSIDE_ENCRYPTION_KMS_KEY_PROPERTY = "crypt.kms.key";
    public static final String PRIVKEY_ALIAS_PROPERTY = "crypt.key.alias";
    public static final String PRIVKEY_PASS_PROPERTY = "crypt.key.password";
    public static final String ENDPOINT_PROPERTY = "endpoint";
    public static final String PATHSTYLEACCESS_PROPERTY = "pathstyleaccess";
    public static final String ACCELERATE_MODE_PROPERTY = "accelerateMode";
    public static final String DIRECTDOWNLOAD_PROPERTY_COMPAT = "downloadfroms3";
    public static final String DIRECTDOWNLOAD_EXPIRE_PROPERTY_COMPAT = "downloadfroms3.expire";
    public static final String USER_AGENT_PREFIX_PROPERTY = "userAgentPrefix";
    public static final String USER_AGENT_SUFFIX_PROPERTY = "userAgentSuffix";
    public static final String DELIMITER = "/";
    @Deprecated
    private static final Pattern MD5_RE = Pattern.compile("[0-9a-f]{32}");
    protected String bucketName;
    protected String bucketNamePrefix;
    protected AWSCredentialsProvider awsCredentialsProvider;
    protected ClientConfiguration clientConfiguration;
    protected EncryptionMaterials encryptionMaterials;
    protected boolean isEncrypted;
    protected CryptoConfiguration cryptoConfiguration;
    protected boolean useServerSideEncryption;
    protected String serverSideKMSKeyID;
    protected AmazonS3 amazonS3;
    protected TransferManager transferManager;

    public void close() {
        this.transferManager.shutdownNow();
        super.close();
    }

    protected void abortOldUploads() {
        if (this.getBooleanProperty("multipart.cleanup.disabled")) {
            log.debug((Object)"Cleanup of old multipart uploads is disabled");
            return;
        }
        new Thread(this::abortOldMultipartUploadsInternal, "Nuxeo-S3-abortOldMultipartUploads-" + this.bucketName).start();
    }

    protected void abortOldMultipartUploadsInternal() {
        int oneDay = 86400000;
        try {
            log.debug((Object)("Starting cleanup of old multipart uploads for bucket: " + this.bucketName));
            this.transferManager.abortMultipartUploads(this.bucketName, new Date(System.currentTimeMillis() - (long)oneDay));
            log.debug((Object)("Cleanup done for bucket: " + this.bucketName));
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 400 || e.getStatusCode() == 404) {
                log.error((Object)"Your cloud provider does not support aborting old uploads");
                return;
            }
            throw new NuxeoException("Failed to abort old uploads", (Throwable)e);
        }
    }

    protected void setupCloudClient() throws IOException {
        int dde;
        AWSConfigurationService service;
        this.bucketName = this.getProperty(BUCKET_NAME_PROPERTY);
        this.bucketNamePrefix = StringUtils.defaultString((String)((String)this.properties.get(BUCKET_PREFIX_PROPERTY)));
        String bucketRegion = this.getProperty(BUCKET_REGION_PROPERTY);
        if (StringUtils.isBlank((CharSequence)bucketRegion)) {
            bucketRegion = NuxeoAWSRegionProvider.getInstance().getRegion();
        }
        String awsID = this.getProperty(AWS_ID_PROPERTY);
        String awsSecret = this.getProperty(AWS_SECRET_PROPERTY);
        String awsToken = this.getProperty(AWS_SESSION_TOKEN_PROPERTY);
        boolean proxyDisabled = Framework.isBooleanPropertyTrue((String)"nuxeo.s3.proxy.disabled");
        String proxyHost = Framework.getProperty((String)"nuxeo.http.proxy.host");
        String proxyPort = Framework.getProperty((String)"nuxeo.http.proxy.port");
        String proxyLogin = Framework.getProperty((String)"nuxeo.http.proxy.login");
        String proxyPassword = Framework.getProperty((String)"nuxeo.http.proxy.password");
        int maxConnections = this.getIntProperty(CONNECTION_MAX_PROPERTY);
        int maxErrorRetry = this.getIntProperty(CONNECTION_RETRY_PROPERTY);
        int connectionTimeout = this.getIntProperty(CONNECTION_TIMEOUT_PROPERTY);
        int socketTimeout = this.getIntProperty(SOCKET_TIMEOUT_PROPERTY);
        String keystoreFile = this.getProperty(KEYSTORE_FILE_PROPERTY);
        String keystorePass = this.getProperty(KEYSTORE_PASS_PROPERTY);
        String privkeyAlias = this.getProperty(PRIVKEY_ALIAS_PROPERTY);
        String privkeyPass = this.getProperty(PRIVKEY_PASS_PROPERTY);
        String endpoint = this.getProperty(ENDPOINT_PROPERTY);
        boolean accelerateModeEnabled = this.getBooleanProperty(ACCELERATE_MODE_PROPERTY);
        boolean pathStyleAccessEnabled = this.getBooleanProperty(PATHSTYLEACCESS_PROPERTY);
        String sseprop = this.getProperty(SERVERSIDE_ENCRYPTION_PROPERTY);
        String userAgentPrefix = this.getProperty(USER_AGENT_PREFIX_PROPERTY);
        String userAgentSuffix = this.getProperty(USER_AGENT_SUFFIX_PROPERTY);
        if (StringUtils.isNotBlank((CharSequence)sseprop)) {
            this.useServerSideEncryption = Boolean.parseBoolean(sseprop);
            this.serverSideKMSKeyID = this.getProperty(SERVERSIDE_ENCRYPTION_KMS_KEY_PROPERTY);
        }
        if (StringUtils.isBlank((CharSequence)this.bucketName)) {
            throw new NuxeoException("Missing conf: bucket");
        }
        if (!StringUtils.isBlank((CharSequence)this.bucketNamePrefix) && !this.bucketNamePrefix.endsWith(DELIMITER)) {
            log.debug((Object)String.format("%s %s S3 bucket prefix should end with '/' : added automatically.", BUCKET_PREFIX_PROPERTY, this.bucketNamePrefix));
            this.bucketNamePrefix = this.bucketNamePrefix + DELIMITER;
        }
        if (StringUtils.isNotBlank((CharSequence)this.namespace)) {
            this.bucketNamePrefix = this.bucketNamePrefix + this.namespace;
            if (!this.bucketNamePrefix.endsWith(DELIMITER)) {
                this.bucketNamePrefix = this.bucketNamePrefix + DELIMITER;
            }
        }
        this.awsCredentialsProvider = S3Utils.getAWSCredentialsProvider(awsID, awsSecret, awsToken);
        this.clientConfiguration = new ClientConfiguration();
        if (!proxyDisabled) {
            if (StringUtils.isNotBlank((CharSequence)proxyHost)) {
                this.clientConfiguration.setProxyHost(proxyHost);
            }
            if (StringUtils.isNotBlank((CharSequence)proxyPort)) {
                this.clientConfiguration.setProxyPort(Integer.parseInt(proxyPort));
            }
            if (StringUtils.isNotBlank((CharSequence)proxyLogin)) {
                this.clientConfiguration.setProxyUsername(proxyLogin);
            }
            if (proxyPassword != null) {
                this.clientConfiguration.setProxyPassword(proxyPassword);
            }
        }
        if (maxConnections > 0) {
            this.clientConfiguration.setMaxConnections(maxConnections);
        }
        if (maxErrorRetry >= 0) {
            this.clientConfiguration.setMaxErrorRetry(maxErrorRetry);
        }
        if (connectionTimeout >= 0) {
            this.clientConfiguration.setConnectionTimeout(connectionTimeout);
        }
        if (socketTimeout >= 0) {
            this.clientConfiguration.setSocketTimeout(socketTimeout);
        }
        if (StringUtils.isNotBlank((CharSequence)userAgentPrefix)) {
            this.clientConfiguration.setUserAgentPrefix(userAgentPrefix);
        }
        if (StringUtils.isNotBlank((CharSequence)userAgentSuffix)) {
            this.clientConfiguration.setUserAgentSuffix(userAgentSuffix);
        }
        if ((service = (AWSConfigurationService)Framework.getService(AWSConfigurationService.class)) != null) {
            service.configureSSL(this.clientConfiguration);
        }
        this.encryptionMaterials = null;
        if (StringUtils.isNotBlank((CharSequence)keystoreFile)) {
            boolean confok = true;
            if (keystorePass == null) {
                log.error((Object)"Keystore password missing");
                confok = false;
            }
            if (StringUtils.isBlank((CharSequence)privkeyAlias)) {
                log.error((Object)"Key alias missing");
                confok = false;
            }
            if (privkeyPass == null) {
                log.error((Object)"Key password missing");
                confok = false;
            }
            if (!confok) {
                throw new NuxeoException("S3 Crypto configuration incomplete");
            }
            try {
                KeyStore keystore;
                File ksFile = new File(keystoreFile);
                try (FileInputStream ksStream = new FileInputStream(ksFile);){
                    keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keystore.load(ksStream, keystorePass.toCharArray());
                }
                if (!keystore.isKeyEntry(privkeyAlias)) {
                    throw new NuxeoException("Alias " + privkeyAlias + " is missing or not a key alias");
                }
                PrivateKey privKey = (PrivateKey)keystore.getKey(privkeyAlias, privkeyPass.toCharArray());
                Certificate cert = keystore.getCertificate(privkeyAlias);
                PublicKey pubKey = cert.getPublicKey();
                KeyPair keypair = new KeyPair(pubKey, privKey);
                this.encryptionMaterials = new EncryptionMaterials(keypair);
                this.cryptoConfiguration = new CryptoConfiguration();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new NuxeoException("Could not read keystore: " + keystoreFile + ", alias: " + privkeyAlias, (Throwable)e);
            }
        }
        this.isEncrypted = this.encryptionMaterials != null;
        Object s3Builder = !this.isEncrypted ? (AmazonS3Builder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(this.awsCredentialsProvider)).withClientConfiguration(this.clientConfiguration) : ((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClientBuilder.standard().withClientConfiguration(this.clientConfiguration)).withCryptoConfiguration(this.cryptoConfiguration).withCredentials(this.awsCredentialsProvider)).withEncryptionMaterials((EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(this.encryptionMaterials));
        if (pathStyleAccessEnabled) {
            log.debug((Object)"Path-style access enabled");
            s3Builder.enablePathStyleAccess();
        }
        s3Builder = StringUtils.isNotBlank((CharSequence)endpoint) ? (AmazonS3Builder)s3Builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, bucketRegion)) : (AmazonS3Builder)s3Builder.withRegion(bucketRegion);
        s3Builder.setAccelerateModeEnabled(Boolean.valueOf(accelerateModeEnabled));
        this.amazonS3 = (AmazonS3)s3Builder.build();
        try {
            if (!this.amazonS3.doesBucketExist(this.bucketName)) {
                this.amazonS3.createBucket(this.bucketName);
                this.amazonS3.setBucketAcl(this.bucketName, CannedAccessControlList.Private);
            }
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        String dd = this.getProperty(DIRECTDOWNLOAD_PROPERTY_COMPAT);
        if (dd != null) {
            this.directDownload = Boolean.parseBoolean(dd);
        }
        if ((dde = this.getIntProperty(DIRECTDOWNLOAD_EXPIRE_PROPERTY_COMPAT)) >= 0) {
            this.directDownloadExpire = dde;
        }
        this.transferManager = TransferManagerBuilder.standard().withS3Client(this.amazonS3).build();
        this.abortOldUploads();
    }

    @Override
    public TransferManager getTransferManager() {
        return this.transferManager;
    }

    protected void removeBinary(String digest) {
        this.amazonS3.deleteObject(this.bucketName, this.bucketNamePrefix + digest);
    }

    public void clear() {
        ObjectListing list = null;
        do {
            if (list == null) {
                ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(this.bucketNamePrefix).withDelimiter(DELIMITER);
                list = this.amazonS3.listObjects(listObjectsRequest);
            } else {
                list = this.amazonS3.listNextBatchOfObjects(list);
            }
            for (S3ObjectSummary summary : list.getObjectSummaries()) {
                this.amazonS3.deleteObject(this.bucketName, summary.getKey());
            }
        } while (list.isTruncated());
        VersionListing vlist = null;
        do {
            if (vlist == null) {
                ListVersionsRequest listVersionsRequest = new ListVersionsRequest().withBucketName(this.bucketName).withPrefix(this.bucketNamePrefix).withDelimiter(DELIMITER);
                vlist = this.amazonS3.listVersions(listVersionsRequest);
            } else {
                vlist = this.amazonS3.listNextBatchOfVersions(vlist);
            }
            for (S3VersionSummary vsummary : vlist.getVersionSummaries()) {
                this.amazonS3.deleteVersion(this.bucketName, vsummary.getKey(), vsummary.getVersionId());
            }
        } while (vlist.isTruncated());
    }

    protected String getSystemPropertyPrefix() {
        return SYSTEM_PROPERTY_PREFIX;
    }

    protected BinaryGarbageCollector instantiateGarbageCollector() {
        return new S3BinaryGarbageCollector(this);
    }

    public void removeBinaries(Collection<String> digests) {
        digests.forEach(this::removeBinary);
    }

    public long lengthOfBlob(String digest) {
        String bucketKey = this.bucketNamePrefix + digest;
        try {
            ObjectMetadata metadata = this.amazonS3.getObjectMetadata(this.bucketName, bucketKey);
            return metadata.getContentLength();
        }
        catch (AmazonServiceException e) {
            if (S3BinaryManager.isMissingKey((AmazonClientException)((Object)e))) {
                return -1L;
            }
            throw e;
        }
    }

    protected static boolean isMissingKey(AmazonClientException e) {
        if (e instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)((Object)e);
            return ase.getStatusCode() == 404 || "NoSuchKey".equals(ase.getErrorCode()) || "Not Found".equals(e.getMessage());
        }
        return false;
    }

    @Deprecated
    public static boolean isMD5(String digest) {
        return MD5_RE.matcher(digest).matches();
    }

    public boolean canAccessBucket() {
        return this.transferManager != null && this.transferManager.getAmazonS3Client().doesBucketExist(this.bucketName);
    }

    protected FileStorage getFileStorage() {
        return new S3FileStorage();
    }

    public AWSCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    public AmazonS3 getAmazonS3() {
        return this.amazonS3;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getBucketPrefix() {
        return this.bucketNamePrefix;
    }

    public String writeBlob(Blob blob) throws IOException {
        if (blob instanceof ManagedBlob) {
            ManagedBlob managedBlob = (ManagedBlob)blob;
            BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(managedBlob.getProviderId());
            if (blobProvider instanceof S3BinaryManager) {
                S3BinaryManager sourceBlobProvider = (S3BinaryManager)blobProvider;
                if (this.getDigestAlgorithm().equals(sourceBlobProvider.getDigestAlgorithm())) {
                    String digest;
                    String key = managedBlob.getKey();
                    int colon = key.indexOf(58);
                    if (colon >= 0) {
                        key = key.substring(colon + 1);
                    }
                    if (this.isValidDigest(key) && (digest = this.copyBlob(sourceBlobProvider, key)) != null) {
                        return digest;
                    }
                }
            }
        }
        return super.writeBlob(blob);
    }

    protected String copyBlob(S3BinaryManager sourceBlobProvider, String digest) throws IOException {
        String sourceBucketName = sourceBlobProvider.bucketName;
        String sourceKey = sourceBlobProvider.bucketNamePrefix + digest;
        String key = this.bucketNamePrefix + digest;
        long t0 = 0L;
        if (log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
            log.debug((Object)("copying blob " + sourceKey + " to " + key));
        }
        try {
            this.amazonS3.getObjectMetadata(this.bucketName, key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("blob " + key + " is already in S3"));
            }
            return digest;
        }
        catch (AmazonServiceException e) {
            ObjectMetadata sourceMetadata;
            if (!S3BinaryManager.isMissingKey((AmazonClientException)((Object)e))) {
                throw new IOException(e);
            }
            try {
                sourceMetadata = this.amazonS3.getObjectMetadata(sourceBucketName, sourceKey);
            }
            catch (AmazonServiceException e2) {
                throw new NuxeoException("Source blob does not exists: s3://" + sourceBucketName + DELIMITER + sourceKey, (Throwable)e2);
            }
            long length = sourceMetadata.getContentLength();
            try {
                CopyObjectRequest copyObjectRequest = new CopyObjectRequest(sourceBucketName, sourceKey, this.bucketName, key);
                if (this.useServerSideEncryption) {
                    if (StringUtils.isNotBlank((CharSequence)this.serverSideKMSKeyID)) {
                        log.warn((Object)"S3 copy not supported with KMS, falling back to regular copy");
                        return null;
                    }
                    ObjectMetadata newObjectMetadata = new ObjectMetadata();
                    newObjectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                    copyObjectRequest.setNewObjectMetadata(newObjectMetadata);
                }
                Copy copy = this.transferManager.copy(copyObjectRequest);
                this.waitForCopyCompletion(copy);
                if (log.isDebugEnabled()) {
                    long dtms = System.currentTimeMillis() - t0;
                    log.debug((Object)("copied blob " + sourceKey + " to " + key + " in " + dtms + "ms"));
                }
                return digest;
            }
            catch (AmazonServiceException e3) {
                String message = "S3 copy not supported from s3://" + sourceBucketName + DELIMITER + sourceKey + " to s3://" + this.bucketName + DELIMITER + key + " (" + length + " bytes)";
                log.warn((Object)(message + ", falling back to regular copy: " + e3.getMessage()));
                log.debug((Object)message, (Throwable)e3);
                return null;
            }
        }
    }

    protected void waitForCopyCompletion(Copy copy) {
        try {
            copy.waitForCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
    }

    protected URI getRemoteUri(String digest, ManagedBlob blob, HttpServletRequest servletRequest) throws IOException {
        String key = this.bucketNamePrefix + digest;
        Date expiration = new Date();
        expiration.setTime(expiration.getTime() + (long)(this.directDownloadExpire * 1000));
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.bucketName, key, HttpMethod.GET);
        request.addRequestParameter("response-content-type", this.getContentTypeHeader((Blob)blob));
        request.addRequestParameter("response-content-disposition", this.getContentDispositionHeader((Blob)blob, null));
        request.setExpiration(expiration);
        URL url = this.amazonS3.generatePresignedUrl(request);
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static class S3BinaryGarbageCollector
    extends AbstractBinaryGarbageCollector<S3BinaryManager> {
        protected S3BinaryGarbageCollector(S3BinaryManager binaryManager) {
            super((CachingBinaryManager)binaryManager);
        }

        public String getId() {
            return "s3:" + ((S3BinaryManager)this.binaryManager).bucketName;
        }

        public void computeToDelete() {
            this.toDelete = new HashSet();
            ObjectListing list = null;
            do {
                if (list == null) {
                    ListObjectsRequest listObjectsRequest = new ListObjectsRequest(((S3BinaryManager)this.binaryManager).bucketName, ((S3BinaryManager)this.binaryManager).bucketNamePrefix, null, S3BinaryManager.DELIMITER, null);
                    list = ((S3BinaryManager)this.binaryManager).amazonS3.listObjects(listObjectsRequest);
                } else {
                    list = ((S3BinaryManager)this.binaryManager).amazonS3.listNextBatchOfObjects(list);
                }
                int prefixLength = ((S3BinaryManager)this.binaryManager).bucketNamePrefix.length();
                for (S3ObjectSummary summary : list.getObjectSummaries()) {
                    String digest = summary.getKey().substring(prefixLength);
                    if (!((S3BinaryManager)this.binaryManager).isValidDigest(digest)) continue;
                    long length = summary.getSize();
                    this.status.sizeBinaries += length;
                    ++this.status.numBinaries;
                    this.toDelete.add(digest);
                }
            } while (list.isTruncated());
        }

        protected void removeUnmarkedBlobsAndUpdateStatus(boolean delete) {
            for (String digest : this.toDelete) {
                long length = ((S3BinaryManager)this.binaryManager).lengthOfBlob(digest);
                if (length < 0L) continue;
                this.status.sizeBinariesGC += length;
                ++this.status.numBinariesGC;
                this.status.sizeBinaries -= length;
                --this.status.numBinaries;
                if (!delete) continue;
                ((S3BinaryManager)this.binaryManager).removeBinary(digest);
            }
        }
    }

    public class S3FileStorage
    implements FileStorage {
        public void storeFile(String digest, File file) throws IOException {
            long t0 = 0L;
            if (log.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
                log.debug((Object)("storing blob " + digest + " to S3"));
            }
            String key = S3BinaryManager.this.bucketNamePrefix + digest;
            try {
                S3BinaryManager.this.amazonS3.getObjectMetadata(S3BinaryManager.this.bucketName, key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("blob " + digest + " is already in S3"));
                }
            }
            catch (AmazonClientException e) {
                PutObjectRequest request;
                if (!S3BinaryManager.isMissingKey(e)) {
                    throw new IOException(e);
                }
                if (!S3BinaryManager.this.isEncrypted) {
                    request = new PutObjectRequest(S3BinaryManager.this.bucketName, key, file);
                    if (S3BinaryManager.this.useServerSideEncryption) {
                        ObjectMetadata objectMetadata = new ObjectMetadata();
                        if (StringUtils.isNotBlank((CharSequence)S3BinaryManager.this.serverSideKMSKeyID)) {
                            SSEAwsKeyManagementParams keyManagementParams = new SSEAwsKeyManagementParams(S3BinaryManager.this.serverSideKMSKeyID);
                            request = request.withSSEAwsKeyManagementParams(keyManagementParams);
                        } else {
                            objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                        }
                        request.setMetadata(objectMetadata);
                    }
                } else {
                    request = new EncryptedPutObjectRequest(S3BinaryManager.this.bucketName, key, file);
                }
                Upload upload = S3BinaryManager.this.transferManager.upload(request);
                try {
                    upload.waitForUploadResult();
                }
                catch (AmazonClientException ee) {
                    throw new IOException(ee);
                }
                catch (InterruptedException ee) {
                    Thread.currentThread().interrupt();
                    throw new NuxeoException((Throwable)ee);
                }
                finally {
                    if (log.isDebugEnabled()) {
                        long dtms = System.currentTimeMillis() - t0;
                        log.debug((Object)("stored blob " + digest + " to S3 in " + dtms + "ms"));
                    }
                }
            }
        }

        public boolean fetchFile(String digest, File file) throws IOException {
            long t0 = 0L;
            if (log.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
                log.debug((Object)("fetching blob " + digest + " from S3"));
            }
            try {
                Download download = S3BinaryManager.this.transferManager.download(new GetObjectRequest(S3BinaryManager.this.bucketName, S3BinaryManager.this.bucketNamePrefix + digest), file);
                download.waitForCompletion();
                boolean bl = true;
                return bl;
            }
            catch (AmazonClientException e) {
                if (!S3BinaryManager.isMissingKey(e)) {
                    throw new IOException(e);
                }
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new NuxeoException((Throwable)e);
            }
            finally {
                if (log.isDebugEnabled()) {
                    long dtms = System.currentTimeMillis() - t0;
                    log.debug((Object)("fetched blob " + digest + " from S3 in " + dtms + "ms"));
                }
            }
        }
    }
}

