/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.executor.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.importer.executor.AbstractImporterExecutor;
import org.nuxeo.ecm.platform.importer.log.BufferredLogger;
import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Produces(value={"text/plain; charset=UTF-8"})
public abstract class AbstractJaxRSImporterExecutor
extends AbstractImporterExecutor {
    public ImporterLogger getLogger() {
        if (log == null) {
            log = new BufferredLogger(this.getJavaLogger());
        }
        return log;
    }

    @GET
    @Produces(value={"text/html; charset=UTF-8"})
    public String index() throws IOException {
        try (InputStream stream = ((Object)((Object)this)).getClass().getResource("/static/importForm.html").openStream();){
            String string = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            return string;
        }
    }

    @GET
    @Path(value="log")
    public String getLogAsString() {
        return this.getLogger().getLoggerBuffer();
    }

    @GET
    @Path(value="logActivate")
    public String enableLogging() {
        this.getLogger().setBufferActive(true);
        return "Logging activated";
    }

    @GET
    @Path(value="logDesactivate")
    public String disableLogging() {
        this.getLogger().setBufferActive(false);
        return "Logging desactivated";
    }

    @GET
    @Path(value="status")
    public String getStatus() {
        return super.getStatus();
    }

    @GET
    @Path(value="running")
    public String running() {
        return Boolean.toString(super.isRunning());
    }

    @GET
    @Path(value="kill")
    public String kill() {
        return super.kill();
    }

    @GET
    @Path(value="waitForAsyncJobs")
    public Response waitForAsyncJobs(@QueryParam(value="timeoutInSeconds") Integer timeoutInSeconds) {
        TransactionHelper.commitOrRollbackTransaction();
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        if (timeoutInSeconds == null) {
            timeoutInSeconds = 120;
        }
        try {
            if (workManager.awaitCompletion((long)timeoutInSeconds.intValue(), TimeUnit.SECONDS)) {
                return Response.ok().build();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Timeout").build();
    }
}

