/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.s3;

import com.iss.nuxeo.bulkimport.source.FileSourceManager;
import com.iss.nuxeo.bulkimport.source.FileSourceProvider;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

public class S3SourceNode
extends FileSourceNode
implements SourceNode {
    private String fileSetProviderId;
    private String location;
    private String name;
    private boolean isFolderish;
    private BlobHolder blobHolder;

    public static S3SourceNode fromString(String sourcePath) {
        return new S3SourceNode(sourcePath);
    }

    public S3SourceNode(String sourcePath) {
        super(sourcePath);
        String[] items = sourcePath.split(":");
        if (items.length != 1 && items.length != 2) {
            throw new NuxeoException("not a valid source path " + sourcePath);
        }
        this.fileSetProviderId = items.length == 1 ? "default" : items[0];
        this.location = items.length == 1 ? items[0] : items[1];
        this.name = this.getLastPathName(this.location);
        this.isFolderish = this.location.endsWith("/");
    }

    public boolean isFolderish() {
        return this.isFolderish;
    }

    public BlobHolder getBlobHolder() throws IOException {
        if (this.blobHolder == null) {
            this.blobHolder = this.getFileServiceProvider().getBlobHolder(this.location);
        }
        return this.blobHolder;
    }

    public List<SourceNode> getChildren() throws IOException {
        return this.getFileServiceProvider().getChildrenSourceNodes(this.location);
    }

    public String getName() {
        return this.name;
    }

    public String getSourcePath() {
        return this.location;
    }

    private FileSourceProvider getFileServiceProvider() {
        FileSourceManager fpm = (FileSourceManager)Framework.getService(FileSourceManager.class);
        if (fpm == null) {
            throw new NuxeoException("Component for FileSourceManager class is not deployed.");
        }
        FileSourceProvider provider = fpm.getFileSourceProvider(this.fileSetProviderId);
        if (provider == null) {
            throw new NuxeoException("The FileSourceProvider [" + this.fileSetProviderId + "] doesn't exist.");
        }
        return provider;
    }

    private String getLastPathName(String location) {
        String path = StringUtils.removeEnd((String)location, (String)"/");
        int index = path.lastIndexOf("/");
        return path.substring(index + 1);
    }
}

